/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.ThreadAction;

public class ThreadTxn {
    public static ThreadAction threadTxnRead(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.READ, action, false);
    }

    public static ThreadAction threadTxnWrite(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.WRITE, action, true);
    }

    public static ThreadAction threadTxnWriteAbort(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.WRITE, action, false);
    }

    static ThreadAction create(Transactional trans, ReadWrite mode, Runnable action, boolean isCommit) {
        return ThreadAction.create(ThreadTxn.beforeAction(trans, mode, isCommit), action, ThreadTxn.afterAction(trans, mode, isCommit));
    }

    private static Runnable beforeAction(Transactional trans, ReadWrite mode, boolean isCommit) {
        return () -> trans.begin(mode);
    }

    private static Runnable afterAction(Transactional trans, ReadWrite mode, boolean isCommit) {
        return () -> {
            switch (mode) {
                case WRITE: {
                    if (isCommit) {
                        trans.commit();
                    } else {
                        trans.abort();
                    }
                    trans.end();
                    break;
                }
                case READ: {
                    if (isCommit) {
                        trans.commit();
                    }
                    trans.end();
                }
            }
        };
    }
}

