/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.util.HashSet;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterExtendByVar;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;

public class TargetContainsPFunction
extends PropertyFunctionBase {
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        if (!(argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding)).getArg().isVariable()) {
            throw new ExprEvalException("Right hand side of tosh:targetContains must be a variable");
        }
        Node targetNode = (Node)argSubject.getArgList().get(0);
        Node shapesGraphNode = (Node)argSubject.getArgList().get(1);
        Model currentModel = ModelFactory.createModelForGraph((Graph)execCxt.getActiveGraph());
        DatasetWithDifferentDefaultModel dataset = new DatasetWithDifferentDefaultModel(currentModel, DatasetImpl.wrap((DatasetGraph)execCxt.getDataset()));
        Model model = dataset.getNamedModel(shapesGraphNode.getURI());
        Resource target = (Resource)model.asRDFNode(targetNode);
        HashSet<Node> focusNodes = new HashSet<Node>();
        SHACLUtil.addNodesInTarget(target, dataset, focusNodes);
        return new QueryIterExtendByVar(binding, (Var)argObject.getArg(), focusNodes.iterator(), execCxt);
    }
}

