/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SystemTriples;

class AbstractTool {
    private static final String DATA_FILE = "-datafile";
    private static final String SHAPES_FILE = "-shapesfile";
    private OntDocumentManager dm = new OntDocumentManager();
    private OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);

    AbstractTool() {
        InputStream shaclTTL = SHACLSystemModel.class.getResourceAsStream("/etc/shacl.ttl");
        Model shacl = JenaUtil.createMemoryModel();
        shacl.read(shaclTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        shacl.add(SystemTriples.getVocabularyModel());
        this.dm.addModel("http://www.w3.org/ns/shacl#", shacl);
        InputStream dashTTL = SHACLSystemModel.class.getResourceAsStream("/etc/dash.ttl");
        Model dash = JenaUtil.createMemoryModel();
        dash.read(dashTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        this.dm.addModel("http://datashapes.org/dash", dash);
        InputStream toshTTL = SHACLSystemModel.class.getResourceAsStream("/etc/tosh.ttl");
        Model tosh = JenaUtil.createMemoryModel();
        tosh.read(toshTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
        this.dm.addModel("http://topbraid.org/tosh", tosh);
        this.spec.setDocumentManager(this.dm);
    }

    protected Model getDataModel(String[] args) throws IOException {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!DATA_FILE.equals(args[i])) continue;
            String dataFileName = args[i + 1];
            OntModel dataModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec);
            File dataFile = new File(dataFileName);
            dataModel.read((InputStream)new FileInputStream(dataFile), "urn:x-base", "TURTLE");
            return dataModel;
        }
        System.err.println("Missing -datafile, e.g.: -datafile myfile.ttl");
        System.exit(0);
        return null;
    }

    protected Model getShapesModel(String[] args) throws IOException {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!SHAPES_FILE.equals(args[i])) continue;
            String fileName = args[i + 1];
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)this.spec);
            File dataFile = new File(fileName);
            model.read((InputStream)new FileInputStream(dataFile), "urn:x-base", "TURTLE");
            return model;
        }
        return null;
    }
}

