/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcat;
import org.apache.jena.sparql.expr.aggregate.AggGroupConcatDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateDropClear;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path1;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.AbstractElementVisitor;
import org.topbraid.spin.arq.Aggregations;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.Describe;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Exists;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Minus;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.NotExists;
import org.topbraid.spin.model.Optional;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.model.TriplePath;
import org.topbraid.spin.model.Union;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.update.Clear;
import org.topbraid.spin.model.update.Create;
import org.topbraid.spin.model.update.DeleteData;
import org.topbraid.spin.model.update.DeleteWhere;
import org.topbraid.spin.model.update.Drop;
import org.topbraid.spin.model.update.InsertData;
import org.topbraid.spin.model.update.Load;
import org.topbraid.spin.model.update.Modify;
import org.topbraid.spin.model.update.Update;
import org.topbraid.spin.query.UpdateFactoryFilter;
import org.topbraid.spin.system.ExtraPrefixes;
import org.topbraid.spin.system.SPINPreferences;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SPINExpressions;
import org.topbraid.spin.util.SPTextUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class ARQ2SPIN {
    private boolean addPrefixes;
    private Model model;
    private static Map<String, List<Resource>> symbolsMap = new HashMap<String, List<Resource>>();
    private String varNamespace = "http://spinrdf.org/sp#";
    private Map<String, Resource> var2Resource = new HashMap<String, Resource>();

    private static void createAliasSymbol(String alias, String original) {
        List<Resource> list = symbolsMap.get(original);
        if (list != null) {
            symbolsMap.put(alias, list);
        }
    }

    public ARQ2SPIN(Model model) {
        this(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARQ2SPIN(Model model, boolean addPrefixes) {
        this.model = model;
        this.addPrefixes = addPrefixes;
        JenaUtil.setGraphReadOptimization(true);
        try {
            StmtIterator it = model.listStatements(null, SP.varName, (RDFNode)null);
            while (it.hasNext()) {
                Resource variable = it.nextStatement().getSubject();
                if (!variable.isURIResource() || !SPINPreferences.get().isCreateURIVariables() && !variable.getURI().startsWith("http://spinrdf.org/sp#arg") && !"http://spinrdf.org/spin#".equals(variable.getNameSpace())) continue;
                Variable var = (Variable)variable.as(Variable.class);
                String name = var.getName();
                this.var2Resource.put(name, var);
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    private void addClearOrDropProperties(UpdateDropClear arqClear, Update spinUpdate) {
        Target target = arqClear.getTarget();
        if (target.isAll()) {
            spinUpdate.addProperty(SP.all, (RDFNode)JenaDatatypes.TRUE);
        } else if (target.isAllNamed()) {
            spinUpdate.addProperty(SP.named, (RDFNode)JenaDatatypes.TRUE);
        } else if (target.isDefault()) {
            spinUpdate.addProperty(SP.default_, (RDFNode)JenaDatatypes.TRUE);
        } else if (target.isOneNamedGraph()) {
            spinUpdate.addProperty(SP.graphIRI, this.model.asRDFNode(target.getGraph()));
        }
        if (arqClear.isSilent()) {
            spinUpdate.addProperty(SP.silent, (RDFNode)JenaDatatypes.TRUE);
        }
    }

    private void addDescribeProperties(org.apache.jena.query.Query arq, Resource spinQuery) {
        if (!arq.isQueryResultStar()) {
            LinkedList<Resource> members = new LinkedList<Resource>();
            for (String varName : arq.getResultVars()) {
                Resource variable = this.getVariable(varName);
                members.add(variable);
            }
            for (Node uriNode : arq.getResultURIs()) {
                members.add(this.model.getResource(uriNode.getURI()));
            }
            spinQuery.addProperty(SP.resultNodes, (RDFNode)this.model.createList(members.iterator()));
        }
    }

    private void addGroupBy(org.apache.jena.query.Query arq, Resource spinQuery) {
        VarExprList namedExprs = arq.getGroupBy();
        Iterator vit = namedExprs.getVars().iterator();
        if (vit.hasNext()) {
            LinkedList<Resource> members = new LinkedList<Resource>();
            while (vit.hasNext()) {
                Var var = (Var)vit.next();
                Expr expr = namedExprs.getExpr(var);
                if (expr == null) {
                    String varName = var.getName();
                    Resource variable = this.getVariable(varName);
                    members.add(variable);
                    continue;
                }
                throw new IllegalArgumentException("Expressions not supported in GROUP BY");
            }
            spinQuery.addProperty(SP.groupBy, (RDFNode)this.model.createList(members.iterator()));
        }
    }

    private void addNamedGraphClauses(org.apache.jena.query.Query arq, Resource spinQuery) {
        for (String graphURI : arq.getGraphURIs()) {
            spinQuery.addProperty(SP.from, (RDFNode)this.model.getResource(graphURI));
        }
        for (String namedGraphURI : arq.getNamedGraphURIs()) {
            spinQuery.addProperty(SP.fromNamed, (RDFNode)this.model.getResource(namedGraphURI));
        }
    }

    private void addSelectProperties(org.apache.jena.query.Query arq, Resource spinQuery) {
        if (arq.isDistinct()) {
            spinQuery.addProperty(SP.distinct, (RDFNode)this.model.createTypedLiteral(true));
        }
        if (arq.isReduced()) {
            spinQuery.addProperty(SP.reduced, (RDFNode)this.model.createTypedLiteral(true));
        }
        if (arq.hasHaving()) {
            List havings = arq.getHavingExprs();
            LinkedList<RDFNode> spinExprs = new LinkedList<RDFNode>();
            for (Expr expr : havings) {
                RDFNode e = this.createExpression(expr);
                spinExprs.add(e);
            }
            spinQuery.addProperty(SP.having, (RDFNode)this.model.createList(spinExprs.iterator()));
        }
        if (!arq.isQueryResultStar()) {
            LinkedList<Object> members = new LinkedList<Object>();
            VarExprList namedExprs = arq.getProject();
            for (Var var : namedExprs.getVars()) {
                Expr expr = namedExprs.getExpr(var);
                if (expr == null) {
                    String varName = var.getName();
                    Resource variable = this.getVariable(varName);
                    members.add(variable);
                    continue;
                }
                RDFNode e = this.createExpression(expr);
                if (var.isAllocVar()) {
                    members.add(e);
                    continue;
                }
                String varName = var.getName();
                Variable variable = SPINFactory.createVariable(this.model, varName);
                variable.addProperty(SP.expression, e);
                members.add(variable);
            }
            spinQuery.addProperty(SP.resultVariables, (RDFNode)this.model.createList(members.iterator()));
        }
        this.addSolutionModifiers(arq, spinQuery);
    }

    private void addSolutionModifiers(org.apache.jena.query.Query arq, Resource query) {
        List orderBy;
        long offset;
        long limit = arq.getLimit();
        if (limit != Long.MIN_VALUE) {
            query.addProperty(SP.limit, (RDFNode)query.getModel().createTypedLiteral(limit));
        }
        if ((offset = arq.getOffset()) != Long.MIN_VALUE) {
            query.addProperty(SP.offset, (RDFNode)query.getModel().createTypedLiteral(offset));
        }
        if ((orderBy = arq.getOrderBy()) != null && !orderBy.isEmpty()) {
            LinkedList<Object> criteria = new LinkedList<Object>();
            for (SortCondition sortCondition : orderBy) {
                Expr expr = sortCondition.getExpression();
                RDFNode node = this.createExpression(expr);
                if (sortCondition.getDirection() == 1) {
                    Resource asc = query.getModel().createResource(SP.Asc);
                    asc.addProperty(SP.expression, node);
                    criteria.add(asc);
                    continue;
                }
                if (sortCondition.getDirection() == -1) {
                    Resource desc = query.getModel().createResource(SP.Desc);
                    desc.addProperty(SP.expression, node);
                    criteria.add(desc);
                    continue;
                }
                criteria.add(node);
            }
            query.addProperty(SP.orderBy, (RDFNode)query.getModel().createList(criteria.iterator()));
        }
    }

    private void addValues(org.apache.jena.query.Query arq, Resource spinQuery) {
        if (arq.hasValues()) {
            List vars = arq.getValuesVariables();
            List bindings = arq.getValuesData();
            Values values = SPINFactory.createValues(this.model, (Table)new TableData(vars, bindings), true);
            spinQuery.addProperty(SP.values, (RDFNode)values);
        }
    }

    private Resource createAggregation(Var var, String str, Resource type) {
        Resource agg = this.model.createResource(type);
        int start = str.indexOf(40);
        if ((str = str.substring(start + 1)).toLowerCase().startsWith("distinct")) {
            agg.addProperty(SP.distinct, (RDFNode)this.model.createTypedLiteral(true));
            str = str.substring(8).trim();
        }
        if (!str.equals("*)")) {
            str = str.substring(0, str.length() - 1);
            RDFNode expr = SPINExpressions.parseExpression(str, this.model);
            agg.addProperty(SP.expression, expr);
        }
        if (!var.isAllocVar()) {
            agg.addProperty(SP.as, (RDFNode)this.getVariable(var.getName()));
        }
        return agg;
    }

    private Clear createClear(UpdateClear arqClear, String uri) {
        Clear spinClear = (Clear)this.model.createResource(uri, SP.Clear).as(Clear.class);
        this.addClearOrDropProperties((UpdateDropClear)arqClear, spinClear);
        return spinClear;
    }

    private Create createCreate(UpdateCreate arqCreate, String uri) {
        Create spinCreate = (Create)this.model.createResource(uri, SP.Create).as(Create.class);
        if (arqCreate.isSilent()) {
            spinCreate.addProperty(SP.silent, (RDFNode)JenaDatatypes.TRUE);
        }
        Node graph = arqCreate.getGraph();
        spinCreate.addProperty(SP.graphIRI, this.model.asRDFNode(graph));
        return spinCreate;
    }

    private DeleteData createDeleteData(UpdateDataDelete arq, String uri) {
        DeleteData spin = (DeleteData)this.model.createResource(uri, SP.DeleteData).as(DeleteData.class);
        spin.addProperty(SP.data, (RDFNode)this.createQuadsList(arq.getQuads()));
        return spin;
    }

    private DeleteWhere createDeleteWhere(UpdateDeleteWhere arqDeleteWhere, String uri) {
        DeleteWhere spinDeleteWhere = (DeleteWhere)this.model.createResource(uri, SP.DeleteWhere).as(DeleteWhere.class);
        RDFList where = this.createQuadsList(arqDeleteWhere.getQuads());
        spinDeleteWhere.addProperty(SP.where, (RDFNode)where);
        return spinDeleteWhere;
    }

    private Drop createDrop(UpdateDrop arqDrop, String uri) {
        Drop spinDrop = (Drop)this.model.createResource(uri, SP.Drop).as(Drop.class);
        this.addClearOrDropProperties((UpdateDropClear)arqDrop, spinDrop);
        return spinDrop;
    }

    public ElementList createElementList(Element pattern) {
        final LinkedList members = new LinkedList();
        if (pattern != null) {
            pattern.visit((ElementVisitor)new AbstractElementVisitor(){
                private boolean first = true;

                @Override
                public void visit(ElementAssign assign) {
                    RDFNode expression = ARQ2SPIN.this.createExpression(assign.getExpr());
                    Variable variable = (Variable)ARQ2SPIN.this.getVariable(assign.getVar().getName()).as(Variable.class);
                    members.add(SPINFactory.createBind(ARQ2SPIN.this.model, variable, expression));
                }

                @Override
                public void visit(ElementBind bind) {
                    RDFNode expression = ARQ2SPIN.this.createExpression(bind.getExpr());
                    Variable variable = (Variable)ARQ2SPIN.this.getVariable(bind.getVar().getName()).as(Variable.class);
                    members.add(SPINFactory.createBind(ARQ2SPIN.this.model, variable, expression));
                }

                @Override
                public void visit(ElementData data) {
                    members.add(SPINFactory.createValues(ARQ2SPIN.this.model, data.getTable(), false));
                }

                @Override
                public void visit(ElementExists exists) {
                    Element element = exists.getElement();
                    ElementList body = ARQ2SPIN.this.createElementList(element);
                    Exists e = SPINFactory.createExists(ARQ2SPIN.this.model, body);
                    members.add(e);
                }

                @Override
                public void visit(ElementFilter filter) {
                    RDFNode expression = ARQ2SPIN.this.createExpression(filter.getExpr());
                    members.add(SPINFactory.createFilter(ARQ2SPIN.this.model, expression));
                }

                @Override
                public void visit(ElementGroup group) {
                    if (this.first) {
                        this.first = false;
                        super.visit(group);
                    } else {
                        ElementList list = ARQ2SPIN.this.createElementList((Element)group);
                        members.add(list);
                    }
                }

                @Override
                public void visit(ElementMinus minus) {
                    Element element = minus.getMinusElement();
                    ElementList body = ARQ2SPIN.this.createElementList(element);
                    Minus spinMinus = SPINFactory.createMinus(ARQ2SPIN.this.model, body);
                    members.add(spinMinus);
                }

                @Override
                public void visit(ElementNamedGraph namedGraph) {
                    Node nameNode = namedGraph.getGraphNameNode();
                    Resource graphNameNode = nameNode.isVariable() ? ARQ2SPIN.this.getVariable(nameNode.getName()) : ARQ2SPIN.this.model.getResource(nameNode.getURI());
                    Element element = namedGraph.getElement();
                    ElementList elements = ARQ2SPIN.this.createElementList(element);
                    NamedGraph ng = SPINFactory.createNamedGraph(ARQ2SPIN.this.model, graphNameNode, elements);
                    members.add(ng);
                }

                @Override
                public void visit(ElementNotExists notExists) {
                    Element element = notExists.getElement();
                    ElementList body = ARQ2SPIN.this.createElementList(element);
                    NotExists ne = SPINFactory.createNotExists(ARQ2SPIN.this.model, body);
                    members.add(ne);
                }

                @Override
                public void visit(ElementOptional optional) {
                    Element element = optional.getOptionalElement();
                    ElementList body = ARQ2SPIN.this.createElementList(element);
                    Optional o = SPINFactory.createOptional(ARQ2SPIN.this.model, body);
                    members.add(o);
                }

                @Override
                public void visit(ElementPathBlock block) {
                    this.visitElements(block.patternElts());
                }

                @Override
                public void visit(ElementService service) {
                    Node node = service.getServiceNode();
                    Resource uri = node.isVariable() ? ARQ2SPIN.this.getVariable(node.getName()) : ARQ2SPIN.this.model.getResource(node.getURI());
                    Element element = service.getElement();
                    ElementList body = ARQ2SPIN.this.createElementList(element);
                    members.add(SPINFactory.createService(ARQ2SPIN.this.model, uri, body));
                }

                @Override
                public void visit(ElementSubQuery subQuery) {
                    org.apache.jena.query.Query arq = subQuery.getQuery();
                    Query spinQuery = ARQ2SPIN.this.createQuery(arq, null);
                    members.add(SPINFactory.createSubQuery(ARQ2SPIN.this.model, spinQuery));
                }

                @Override
                public void visit(ElementTriplesBlock el) {
                    this.visitElements(el.patternElts());
                }

                @Override
                public void visit(ElementUnion arqUnion) {
                    List arqElements = arqUnion.getElements();
                    LinkedList<ElementList> elements = new LinkedList<ElementList>();
                    for (Element arqElement : arqElements) {
                        ElementList element = ARQ2SPIN.this.createElementList(arqElement);
                        elements.add(element);
                    }
                    Union union = (Union)ARQ2SPIN.this.model.createResource(SP.Union).as(Union.class);
                    union.addProperty(SP.elements, (RDFNode)ARQ2SPIN.this.model.createList(elements.iterator()));
                    members.add(union);
                }

                private void visitElements(Iterator it) {
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof org.apache.jena.sparql.core.TriplePath) {
                            org.apache.jena.sparql.core.TriplePath path = (org.apache.jena.sparql.core.TriplePath)next;
                            if (path.isTriple()) {
                                next = path.asTriple();
                            } else {
                                Path p = path.getPath();
                                Resource pathResource = ARQ2SPIN.this.createPath(p);
                                Resource subject = (Resource)ARQ2SPIN.this.getNode(path.getSubject());
                                RDFNode object = ARQ2SPIN.this.getNode(path.getObject());
                                TriplePath triplePath = SPINFactory.createTriplePath(ARQ2SPIN.this.model, subject, pathResource, object);
                                members.add(triplePath);
                            }
                        }
                        if (!(next instanceof Triple)) continue;
                        Triple triple = (Triple)next;
                        RDFNode subject = ARQ2SPIN.this.getNode(triple.getSubject());
                        Resource predicate = (Resource)ARQ2SPIN.this.getNode(triple.getPredicate());
                        RDFNode object = ARQ2SPIN.this.getNode(triple.getObject());
                        members.add(SPINFactory.createTriplePattern(ARQ2SPIN.this.model, subject, predicate, object));
                    }
                }
            });
        }
        return (ElementList)this.model.createList(members.iterator()).as(ElementList.class);
    }

    public RDFNode createExpression(Expr expr) {
        NodeValue constant = expr.getConstant();
        if (constant != null) {
            Node node = constant.asNode();
            return this.model.asRDFNode(node);
        }
        if (expr instanceof ExprAggregator) {
            return this.createAggregation((ExprAggregator)expr);
        }
        ExprVar var = expr.getExprVar();
        if (var != null) {
            String varName = var.getVarName();
            return this.getVariable(varName);
        }
        return this.createFunctionCall(expr);
    }

    private RDFNode createAggregation(ExprAggregator agg) {
        String str = agg.asSparqlExpr(new SerializationContext());
        int opening = str.indexOf(40);
        if (opening > 0) {
            String name = str.substring(0, opening).toUpperCase().trim();
            Resource aggType = Aggregations.getType(name);
            if (aggType != null) {
                String separator;
                if ((agg.getAggregator() instanceof AggGroupConcat || agg.getAggregator() instanceof AggGroupConcatDistinct) && (separator = this.getGroupConcatSeparator(agg.getAggregator())) != null) {
                    int semi = str.indexOf(59);
                    String sub = str.substring(0, semi) + ")";
                    Resource result = this.createAggregation(agg.getAggVar().asVar(), sub, aggType);
                    result.addProperty(SP.separator, (RDFNode)this.model.createTypedLiteral(separator));
                    return result;
                }
                return this.createAggregation(agg.getAggVar().asVar(), str, aggType);
            }
            throw new IllegalArgumentException("Expected aggregation");
        }
        throw new IllegalArgumentException("Malformed aggregation");
    }

    private RDFNode createFunctionCall(Expr expr) {
        String ns;
        ExprFunction function = expr.getFunction();
        Resource f = this.getFunction(function);
        FunctionCall call = SPINFactory.createFunctionCall(this.model, f);
        if (this.addPrefixes && (ns = f.getNameSpace()) != null && this.model.getNsURIPrefix(ns) == null) {
            Map<String, String> extras = ExtraPrefixes.getExtraPrefixes();
            for (String prefix : extras.keySet()) {
                if (!ns.equals(extras.get(prefix))) continue;
                this.model.setNsPrefix(prefix, ns);
            }
        }
        List<RDFNode> params = this.createParameters(function);
        List<Argument> args = ((Function)f.as(Function.class)).getArguments(true);
        for (int i = 0; i < params.size(); ++i) {
            RDFNode arg = params.get(i);
            Property predicate = i < args.size() ? args.get(i).getPredicate() : this.model.getProperty("http://spinrdf.org/sp#arg" + (i + 1));
            call.addProperty(predicate, arg);
        }
        if (function instanceof ExprFunctionOp) {
            Element element = ((ExprFunctionOp)function).getElement();
            ElementList elements = this.createElementList(element);
            call.addProperty(SP.elements, (RDFNode)elements);
        }
        return call;
    }

    private InsertData createInsertData(UpdateDataInsert arq, String uri) {
        InsertData spin = (InsertData)this.model.createResource(uri, SP.InsertData).as(InsertData.class);
        spin.addProperty(SP.data, (RDFNode)this.createQuadsList(arq.getQuads()));
        return spin;
    }

    private Load createLoad(UpdateLoad arqLoad, String uri) {
        Load spinLoad = (Load)this.model.createResource(uri, SP.Load).as(Load.class);
        String documentURI = arqLoad.getSource();
        spinLoad.addProperty(SP.document, (RDFNode)this.model.getResource(documentURI));
        Node graphName = arqLoad.getDest();
        if (graphName != null) {
            spinLoad.addProperty(SP.into, this.model.asRDFNode(graphName));
        }
        return spinLoad;
    }

    private Resource createPath(Path path) {
        if (path instanceof P_Link) {
            P_Link link = (P_Link)path;
            Node node = link.getNode();
            return (Resource)this.model.asRDFNode(node);
        }
        if (path instanceof P_ZeroOrMore1) {
            return this.createMod((P_Path1)((P_ZeroOrMore1)path), 0L, -2L);
        }
        if (path instanceof P_ZeroOrMoreN) {
            return this.createMod((P_Path1)((P_ZeroOrMoreN)path), 0L, -2L);
        }
        if (path instanceof P_ZeroOrOne) {
            return this.createMod((P_Path1)((P_ZeroOrOne)path), 0L, -1L);
        }
        if (path instanceof P_OneOrMore1) {
            return this.createMod((P_Path1)((P_OneOrMore1)path), 1L, -2L);
        }
        if (path instanceof P_OneOrMoreN) {
            return this.createMod((P_Path1)((P_OneOrMoreN)path), 1L, -2L);
        }
        if (path instanceof P_FixedLength) {
            P_FixedLength mod = (P_FixedLength)path;
            long count = mod.getCount();
            return this.createMod((P_Path1)((P_FixedLength)path), count, count);
        }
        if (path instanceof P_Mod) {
            P_Mod mod = (P_Mod)path;
            long min = mod.getMin();
            long max = mod.getMax();
            return this.createMod((P_Path1)((P_Mod)path), min, max);
        }
        if (path instanceof P_Alt) {
            P_Alt alt = (P_Alt)path;
            Resource path1 = this.createPath(alt.getLeft());
            Resource path2 = this.createPath(alt.getRight());
            Resource r = this.model.createResource(SP.AltPath);
            r.addProperty(SP.path1, (RDFNode)path1);
            r.addProperty(SP.path2, (RDFNode)path2);
            return r;
        }
        if (path instanceof P_Inverse) {
            P_Inverse reverse = (P_Inverse)path;
            Resource r = this.model.createResource(SP.ReversePath);
            Resource path1 = this.createPath(reverse.getSubPath());
            r.addProperty(SP.subPath, (RDFNode)path1);
            return r;
        }
        if (path instanceof P_Seq) {
            P_Seq seq = (P_Seq)path;
            Resource path1 = this.createPath(seq.getLeft());
            Resource path2 = this.createPath(seq.getRight());
            Resource r = this.model.createResource(SP.SeqPath);
            r.addProperty(SP.path1, (RDFNode)path1);
            r.addProperty(SP.path2, (RDFNode)path2);
            return r;
        }
        if (path instanceof P_ReverseLink) {
            P_ReverseLink rl = (P_ReverseLink)path;
            Resource r = this.model.createResource(SP.ReverseLinkPath);
            r.addProperty(SP.node, this.model.asRDFNode(rl.getNode()));
            return r;
        }
        throw new IllegalArgumentException("Unsupported Path element: " + path + " of type " + path.getClass());
    }

    private Resource createMod(P_Path1 path, long min, long max) {
        Resource subR = this.createPath(path.getSubPath());
        Resource r = this.model.createResource(SP.ModPath);
        r.addProperty(SP.subPath, (RDFNode)subR);
        r.addProperty(SP.modMax, (RDFNode)this.model.createTypedLiteral((Object)max, XSD.integer.getURI()));
        r.addProperty(SP.modMin, (RDFNode)this.model.createTypedLiteral((Object)min, XSD.integer.getURI()));
        return r;
    }

    private List<RDFNode> createParameters(ExprFunction function) {
        LinkedList<RDFNode> params = new LinkedList<RDFNode>();
        List args = function.getArgs();
        for (Expr argExpr : args) {
            RDFNode param = this.createExpression(argExpr);
            params.add(param);
        }
        return params;
    }

    private Resource createHead(Template template) {
        LinkedList<Resource> members = new LinkedList<Resource>();
        for (Triple triple : template.getTriples()) {
            Resource tripleTemplate = this.model.createResource();
            tripleTemplate.addProperty(SP.subject, this.getNode(triple.getSubject()));
            tripleTemplate.addProperty(SP.predicate, this.getNode(triple.getPredicate()));
            tripleTemplate.addProperty(SP.object, this.getNode(triple.getObject()));
            members.add(tripleTemplate);
        }
        return this.model.createList(members.iterator());
    }

    private RDFList createQuadsList(List<Quad> quads) {
        LinkedList<Resource> members = new LinkedList<Resource>();
        Node nestedGraph = null;
        LinkedList<Resource> nested = null;
        Iterator<Quad> it = quads.iterator();
        while (it.hasNext()) {
            Quad quad = it.next();
            if (nestedGraph != null && !nestedGraph.equals((Object)quad.getGraph())) {
                members.add(this.createNestedNamedGraph(nestedGraph, nested));
                nestedGraph = null;
            }
            Resource triple = this.createTriple(quad);
            if (quad.isDefaultGraph()) {
                members.add(triple);
                continue;
            }
            if (!quad.getGraph().equals(nestedGraph)) {
                nested = new LinkedList<Resource>();
                nestedGraph = quad.getGraph();
            }
            nested.add(triple);
            if (it.hasNext()) continue;
            members.add(this.createNestedNamedGraph(nestedGraph, nested));
        }
        return this.model.createList(members.iterator());
    }

    private Resource createNestedNamedGraph(Node nestedGraph, List<Resource> nested) {
        RDFList nestedMembers = this.model.createList(nested.iterator());
        Resource graphNode = nestedGraph.isVariable() ? this.getVariable(nestedGraph.getName()) : (Resource)this.model.asRDFNode(nestedGraph);
        return SPINFactory.createNamedGraph(this.model, graphNode, nestedMembers);
    }

    private Resource createTriple(Quad quad) {
        Resource triple = this.model.createResource();
        triple.addProperty(SP.subject, this.getNode(quad.getSubject()));
        triple.addProperty(SP.predicate, this.getNode(quad.getPredicate()));
        triple.addProperty(SP.object, this.getNode(quad.getObject()));
        return triple;
    }

    public Query createQuery(org.apache.jena.query.Query arq, String uri) {
        Resource spinQuery = this.model.createResource(uri);
        this.addNamedGraphClauses(arq, spinQuery);
        ElementList where = this.createElementList(arq.getQueryPattern());
        spinQuery.addProperty(SP.where, (RDFNode)where);
        if (arq.isAskType()) {
            spinQuery.addProperty(RDF.type, (RDFNode)SP.Ask);
            this.addValues(arq, spinQuery);
            return (Query)spinQuery.as(Ask.class);
        }
        if (arq.isConstructType()) {
            Resource head = this.createHead(arq.getConstructTemplate());
            spinQuery.addProperty(RDF.type, (RDFNode)SP.Construct);
            spinQuery.addProperty(SP.templates, (RDFNode)head);
            this.addSolutionModifiers(arq, spinQuery);
            this.addValues(arq, spinQuery);
            return (Query)spinQuery.as(Construct.class);
        }
        if (arq.isSelectType()) {
            spinQuery.addProperty(RDF.type, (RDFNode)SP.Select);
            Select select = (Select)spinQuery.as(Select.class);
            this.addSelectProperties(arq, spinQuery);
            this.addGroupBy(arq, spinQuery);
            this.addValues(arq, spinQuery);
            return select;
        }
        if (arq.isDescribeType()) {
            spinQuery.addProperty(RDF.type, (RDFNode)SP.Describe);
            Describe describe = (Describe)spinQuery.as(Describe.class);
            this.addDescribeProperties(arq, spinQuery);
            this.addSolutionModifiers(arq, spinQuery);
            this.addValues(arq, spinQuery);
            return describe;
        }
        throw new IllegalArgumentException("Unsupported SPARQL query type");
    }

    private Modify createModify(UpdateModify arq, String uri) {
        Element where;
        Modify result = (Modify)this.model.createResource(uri, SP.Modify).as(Modify.class);
        Node withIRI = arq.getWithIRI();
        if (withIRI != null) {
            result.addProperty(SP.with, this.model.asRDFNode(withIRI));
        }
        if (arq.hasDeleteClause()) {
            List deletes = arq.getDeleteQuads();
            result.addProperty(SP.deletePattern, (RDFNode)this.createQuadsList(deletes));
        }
        if (arq.hasInsertClause()) {
            List inserts = arq.getInsertQuads();
            result.addProperty(SP.insertPattern, (RDFNode)this.createQuadsList(inserts));
        }
        if ((where = arq.getWherePattern()) != null) {
            ElementList spinWhere = this.createElementList(where);
            result.addProperty(SP.where, (RDFNode)spinWhere);
        }
        for (Node using : arq.getUsing()) {
            result.addProperty(SP.using, this.model.asRDFNode(using));
        }
        for (Node usingNamed : arq.getUsingNamed()) {
            result.addProperty(SP.usingNamed, this.model.asRDFNode(usingNamed));
        }
        return result;
    }

    public Update createUpdate(org.apache.jena.update.Update arq, String uri) {
        if (arq instanceof UpdateModify) {
            return this.createModify((UpdateModify)arq, uri);
        }
        if (arq instanceof UpdateClear) {
            return this.createClear((UpdateClear)arq, uri);
        }
        if (arq instanceof UpdateCreate) {
            return this.createCreate((UpdateCreate)arq, uri);
        }
        if (arq instanceof UpdateDeleteWhere) {
            return this.createDeleteWhere((UpdateDeleteWhere)arq, uri);
        }
        if (arq instanceof UpdateDrop) {
            return this.createDrop((UpdateDrop)arq, uri);
        }
        if (arq instanceof UpdateLoad) {
            return this.createLoad((UpdateLoad)arq, uri);
        }
        if (arq instanceof UpdateDataDelete) {
            return this.createDeleteData((UpdateDataDelete)arq, uri);
        }
        if (arq instanceof UpdateDataInsert) {
            return this.createInsertData((UpdateDataInsert)arq, uri);
        }
        throw new IllegalArgumentException("Unsupported SPARQL Update type for " + arq);
    }

    private Resource getFunction(ExprFunction function) {
        String iri;
        List<Resource> list;
        String symbol = function.getOpName();
        if (symbol == null) {
            symbol = function.getFunctionSymbol().getSymbol();
        }
        if (symbol != null && (list = symbolsMap.get(symbol.toLowerCase())) != null) {
            if (list.size() == 1) {
                return list.get(0);
            }
            for (Resource f : list) {
                int count = 0;
                StmtIterator dit = f.listProperties(SPIN.constraint);
                while (dit.hasNext()) {
                    dit.next();
                    ++count;
                }
                int argsCount = function.getArgs().size();
                if (argsCount != count) continue;
                return f;
            }
        }
        if ((iri = function.getFunctionIRI()) != null) {
            return this.model.getResource(iri);
        }
        if ("uuid".equals(symbol)) {
            return this.model.getResource("http://spinrdf.org/sp#UUID");
        }
        if ("struuid".equals(symbol)) {
            return this.model.getResource("http://spinrdf.org/sp#struuid");
        }
        if (symbol != null) {
            return this.model.getResource("http://www.w3.org/2005/xpath-functions#" + symbol);
        }
        return null;
    }

    private String getGroupConcatSeparator(Aggregator agg) {
        if (agg instanceof AggGroupConcat) {
            return ((AggGroupConcat)agg).getSeparator();
        }
        return ((AggGroupConcatDistinct)agg).getSeparator();
    }

    private RDFNode getNode(Node node) {
        if (node.isVariable()) {
            String name = node.getName();
            return this.getVariable(name);
        }
        return this.model.asRDFNode(node);
    }

    public static String getTextOnly(Resource spinCommand) {
        Statement s = spinCommand.getProperty(SP.text);
        if (s != null) {
            if (SPTextUtil.hasSPINRDF(spinCommand)) {
                return null;
            }
            return s.getString();
        }
        return null;
    }

    private Resource getVariable(String name) {
        Resource old = this.var2Resource.get(name);
        if (old != null) {
            return old;
        }
        if (SPINPreferences.get().isCreateURIVariables()) {
            String uri = this.varNamespace + "_" + name;
            Resource var = this.model.createResource(uri, SP.Variable);
            var.addProperty(SP.varName, (RDFNode)this.model.createTypedLiteral(name));
            this.var2Resource.put(name, var);
            return var;
        }
        Variable var = SPINFactory.createVariable(this.model, name);
        if (SPINPreferences.get().isReuseLocalVariables()) {
            this.var2Resource.put(name, var);
        }
        return var;
    }

    public String getVarNamespace() {
        return this.varNamespace;
    }

    public static Query parseQuery(String str, Model model) {
        org.apache.jena.query.Query arq = ARQFactory.get().createQuery(model, str);
        ARQ2SPIN a2s = new ARQ2SPIN(model);
        return a2s.createQuery(arq, null);
    }

    public static Update parseUpdate(String str, Model model) {
        String prefixes = ARQFactory.get().createPrefixDeclarations(model);
        UpdateRequest request = UpdateFactoryFilter.get().create(prefixes + str);
        ARQ2SPIN a2s = new ARQ2SPIN(model);
        return a2s.createUpdate((org.apache.jena.update.Update)request.getOperations().get(0), null);
    }

    public void setVarNamespace(String value) {
        this.varNamespace = value;
    }

    static {
        Model symbolsModel = SPL.getModel();
        StmtIterator it = symbolsModel.listStatements(null, SPIN.symbol, (RDFNode)null);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getObject().isLiteral()) continue;
            String symbol = s.getLiteral().getLexicalForm().toLowerCase();
            Resource f = s.getSubject();
            if (!f.isURIResource()) continue;
            List<Resource> list = symbolsMap.get(symbol);
            if (list == null) {
                list = new ArrayList<Resource>(1);
                symbolsMap.put(symbol, list);
            }
            list.add(f);
        }
        ARQ2SPIN.createAliasSymbol("notin", "not in");
        ARQ2SPIN.createAliasSymbol("notexists", "not exists");
    }
}

