/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.shacl.arq.OptionalArgsFunction;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.arq.SPINFunctionsCache;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.system.SPINArgumentChecker;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.OntologyOptimizations;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINARQFunction
implements org.apache.jena.sparql.function.Function,
OptionalArgsFunction,
SPINFunctionFactory {
    private org.apache.jena.query.Query arqQuery;
    private List<String> argNames = new ArrayList<String>();
    private List<Node> argNodes = new ArrayList<Node>();
    private boolean cachable;
    private boolean cachableForOntologies;
    private List<Boolean> optional = new LinkedList<Boolean>();
    private String queryString;
    private Function spinFunction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPINARQFunction(Function spinFunction) {
        this.spinFunction = spinFunction;
        this.cachable = spinFunction.hasProperty(SPIN.cachable, (RDFNode)JenaDatatypes.TRUE);
        this.cachableForOntologies = spinFunction.hasProperty(SPIN.cachableForOntologies, (RDFNode)JenaDatatypes.TRUE);
        try {
            Query spinQuery = (Query)spinFunction.getBody();
            this.queryString = ARQFactory.get().createCommandString(spinQuery);
            this.arqQuery = ARQFactory.get().createQuery(this.queryString);
            JenaUtil.setGraphReadOptimization(true);
            try {
                for (Argument arg : spinFunction.getArguments(true)) {
                    String varName = arg.getVarName();
                    if (varName == null) {
                        throw new IllegalStateException("Argument " + arg + " of " + spinFunction + " does not have a valid predicate");
                    }
                    this.argNames.add(varName);
                    this.argNodes.add(arg.getPredicate().asNode());
                    this.optional.add(arg.isOptional());
                }
            }
            finally {
                JenaUtil.setGraphReadOptimization(false);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Function " + spinFunction.getURI() + " does not define a valid body", ex);
        }
    }

    public void build(String uri, ExprList args) {
    }

    public org.apache.jena.sparql.function.Function create(String uri) {
        return this;
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Graph activeGraph = env.getActiveGraph();
        String optimizedKey = null;
        if (this.cachableForOntologies) {
            optimizedKey = OntologyOptimizations.get().getKeyIfEnabledFor(activeGraph);
        }
        Model model = activeGraph != null ? ModelFactory.createModelForGraph((Graph)activeGraph) : ModelFactory.createDefaultModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        Node t = binding.get(Var.alloc((String)"this"));
        if (t != null) {
            bindings.add("this", model.asRDFNode(t));
        }
        Node[] argsForCache = this.cachable || optimizedKey != null ? new Node[args.size()] : null;
        for (int i = 0; i < args.size(); ++i) {
            NodeValue x;
            Expr expr = args.get(i);
            if (expr == null || expr.isVariable() && !binding.contains(expr.asVar()) || (x = expr.eval(binding, env)) == null) continue;
            String argName = i < this.argNames.size() ? this.argNames.get(i) : "arg" + (i + 1);
            bindings.add(argName, model.asRDFNode(x.asNode()));
            if (!this.cachable && optimizedKey == null) continue;
            argsForCache[i] = x.asNode();
        }
        if (SPINArgumentChecker.get() != null) {
            SPINArgumentChecker.get().check(this.spinFunction, bindings);
        }
        Dataset dataset = DatasetImpl.wrap((DatasetGraph)env.getDataset());
        if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
            NodeValue result;
            StringBuffer sb = new StringBuffer();
            sb.append("SPIN Function ");
            sb.append(SSE.str((Node)NodeFactory.createURI((String)uri), (PrefixMapping)model));
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Expr expr = args.get(i);
                if ((expr = Substitute.substitute((Expr)expr, (Binding)binding)) == null) {
                    sb.append("?unbound");
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IndentedWriter iOut = new IndentedWriter((OutputStream)bos);
                ExprUtils.fmtSPARQL((IndentedWriter)iOut, (Expr)expr, (SerializationContext)new SerializationContext((PrefixMapping)model));
                iOut.flush();
                sb.append(bos.toString());
            }
            sb.append(")");
            long startTime = System.currentTimeMillis();
            try {
                if (this.cachable) {
                    result = SPINFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, argsForCache);
                } else if (optimizedKey != null) {
                    SPINFunctionsCache cache = OntologyOptimizations.get().getSPINFunctionsCache(optimizedKey);
                    result = cache.execute(this, dataset, model, (QuerySolution)bindings, argsForCache);
                } else {
                    result = this.executeBody(dataset, model, (QuerySolution)bindings);
                }
                sb.append(" = ");
                sb.append(FmtUtils.stringForNode((Node)result.asNode(), (PrefixMapping)model));
            }
            catch (ExprEvalException ex) {
                sb.append(" : ");
                sb.append(ex.getLocalizedMessage());
                throw ex;
            }
            finally {
                long endTime = System.currentTimeMillis();
                SPINStatistics stats = new SPINStatistics(sb.toString(), this.queryString, endTime - startTime, startTime, NodeFactory.createURI((String)uri));
                SPINStatisticsManager.get().addSilently(Collections.singleton(stats));
            }
            return result;
        }
        if (this.cachable) {
            return SPINFunctionsCache.get().execute(this, dataset, model, (QuerySolution)bindings, argsForCache);
        }
        if (optimizedKey != null) {
            SPINFunctionsCache cache = OntologyOptimizations.get().getSPINFunctionsCache(optimizedKey);
            return cache.execute(this, dataset, model, (QuerySolution)bindings, argsForCache);
        }
        return this.executeBody(dataset, model, (QuerySolution)bindings);
    }

    public NodeValue executeBody(Model model, QuerySolution bindings) {
        return this.executeBody(null, model, bindings);
    }

    private QueryExecution createQueryExecution(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        if (dataset == null) {
            return ARQFactory.get().createQueryExecution(this.arqQuery, defaultModel, bindings);
        }
        DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(defaultModel, dataset);
        return ARQFactory.get().createQueryExecution(this.arqQuery, newDataset, bindings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeValue executeBody(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        Throwable throwable = null;
        try (QueryExecution qexec = this.createQueryExecution(dataset, defaultModel, bindings);){
            List resultVars;
            String varName;
            QuerySolution s;
            RDFNode resultNode;
            if (this.arqQuery.isAskType()) {
                boolean result = qexec.execAsk();
                NodeValue nodeValue = NodeValue.makeBoolean((boolean)result);
                return nodeValue;
            }
            if (!this.arqQuery.isSelectType()) throw new ExprEvalException("Body must be ASK or SELECT query");
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext() && (resultNode = (s = rs.nextSolution()).get(varName = (String)(resultVars = rs.getResultVars()).get(0))) != null) {
                NodeValue nodeValue = NodeValue.makeNode((Node)resultNode.asNode());
                return nodeValue;
            }
            try {
                throw new ExprEvalException("Empty result set for SPIN function");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String[] getArgNames() {
        return this.argNames.toArray(new String[0]);
    }

    public Node[] getArgPropertyNodes() {
        return this.argNodes.toArray(new Node[0]);
    }

    public org.apache.jena.query.Query getBodyQuery() {
        return this.arqQuery;
    }

    public Function getSPINFunction() {
        return this.spinFunction;
    }

    @Override
    public boolean isOptionalArg(int index) {
        return this.optional.get(index);
    }
}

