/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.vocabulary.SP;

public class VariableImpl
extends AbstractSPINResourceImpl
implements Variable {
    public VariableImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    private void addTriplePatterns(Property predicate, Set<TriplePattern> results) {
        StmtIterator it = this.getModel().listStatements(null, predicate, (RDFNode)this);
        while (it.hasNext()) {
            Resource subject = it.nextStatement().getSubject();
            results.add((TriplePattern)subject.as(TriplePattern.class));
        }
    }

    @Override
    public String getName() {
        return this.getString(SP.varName);
    }

    @Override
    public Set<TriplePattern> getTriplePatterns() {
        HashSet<TriplePattern> results = new HashSet<TriplePattern>();
        this.addTriplePatterns(SP.subject, results);
        this.addTriplePatterns(SP.predicate, results);
        this.addTriplePatterns(SP.object, results);
        return results;
    }

    @Override
    public boolean isBlankNodeVar() {
        String name = this.getName();
        if (name != null) {
            return name.startsWith("?");
        }
        return false;
    }

    @Override
    public void print(PrintContext p) {
        String name = this.getName();
        if (name.startsWith("?")) {
            p.print("_:");
            p.print(name.substring(1));
        } else {
            p.printVariable(name);
        }
    }
}

