/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.update.impl;

import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.update.Modify;
import org.topbraid.spin.model.update.impl.UpdateImpl;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public class ModifyImpl
extends UpdateImpl
implements Modify {
    public ModifyImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    public List<Resource> getUsing() {
        return JenaUtil.getResourceProperties(this, SP.using);
    }

    public List<Resource> getUsingNamed() {
        return JenaUtil.getResourceProperties(this, SP.usingNamed);
    }

    @Override
    public void printSPINRDF(PrintContext p) {
        this.printComment(p);
        this.printPrefixes(p);
        Resource iri = JenaUtil.getResourceProperty(this, SP.graphIRI);
        Resource with = JenaUtil.getResourceProperty(this, SP.with);
        if (with != null) {
            p.printIndentation(p.getIndentation());
            p.printKeyword("WITH");
            p.print(" ");
            p.printURIResource(with);
            p.println();
        }
        if (this.printTemplates(p, SP.deletePattern, "DELETE", this.hasProperty(SP.deletePattern), iri)) {
            p.print("\n");
        }
        if (this.printTemplates(p, SP.insertPattern, "INSERT", this.hasProperty(SP.insertPattern), iri)) {
            p.print("\n");
        }
        for (Resource using : this.getUsing()) {
            p.printKeyword("USING");
            p.print(" ");
            p.printURIResource(using);
            p.println();
        }
        for (Resource usingNamed : this.getUsingNamed()) {
            p.printKeyword("USING");
            p.print(" ");
            p.printKeyword("NAMED");
            p.print(" ");
            p.printURIResource(usingNamed);
            p.println();
        }
        this.printWhere(p);
    }
}

