/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 */
package org.topbraid.shacl.arq.functions;

import java.util.regex.Pattern;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.topbraid.spin.arq.AbstractFunction1;

public class CheckRegexSyntaxFunction extends AbstractFunction1 {

	@Override
	protected NodeValue exec(Node regexNode, FunctionEnv env) {
		if(regexNode == null || !regexNode.isLiteral()) {
			return NodeValue.makeString("Invalid argument to spif:checkRegexSyntax: " + regexNode);
		}
		else {
			String str = regexNode.getLiteralLexicalForm();
			try {
				Pattern.compile(str);
			}
			catch(Exception ex) {
				return NodeValue.makeString(ex.getMessage());
			}
			throw new ExprEvalException(); // OK
		}
	}
}
