/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.ImportProperties;
import org.topbraid.jenax.util.JenaUtilHelper;

public class JenaUtil {
    private static JenaUtilHelper helper = new JenaUtilHelper();
    private static Model dummyModel = JenaUtil.createDefaultModel();
    public static final String WITH_IMPORTS_PREFIX = "http://rdfex.org/withImports?uri=";

    public static JenaUtilHelper setHelper(JenaUtilHelper h) {
        JenaUtilHelper old = helper;
        helper = h;
        return old;
    }

    public static final JenaUtilHelper getHelper() {
        return helper;
    }

    public static void addTransitiveObjects(Set<Resource> results, Resource subject, Property predicate) {
        helper.setGraphReadOptimization(true);
        try {
            JenaUtil.addTransitiveObjects(results, new HashSet<Resource>(), subject, predicate);
        }
        finally {
            helper.setGraphReadOptimization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransitiveObjects(Set<Resource> resources, Set<Resource> reached, Resource subject, Property predicate) {
        resources.add(subject);
        reached.add(subject);
        try (StmtIterator it = subject.listProperties(predicate);){
            while (it.hasNext()) {
                RDFNode object = ((Statement)it.next()).getObject();
                if (!(object instanceof Resource) || reached.contains(object)) continue;
                JenaUtil.addTransitiveObjects(resources, reached, (Resource)object, predicate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransitiveSubjects(Set<Resource> reached, Resource object, Property predicate, ProgressMonitor monitor) {
        if (object != null) {
            reached.add(object);
            try (StmtIterator it = object.getModel().listStatements(null, predicate, (RDFNode)object);){
                while (it.hasNext()) {
                    if (monitor != null && monitor.isCanceled()) {
                        it.close();
                        return;
                    }
                    Resource subject = ((Statement)it.next()).getSubject();
                    if (reached.contains(subject)) continue;
                    JenaUtil.addTransitiveSubjects(reached, subject, predicate, monitor);
                }
            }
        }
    }

    public static Binding asBinding(QuerySolution map) {
        if (map != null) {
            BindingHashMap result = new BindingHashMap();
            Iterator varNames = map.varNames();
            while (varNames.hasNext()) {
                String varName = (String)varNames.next();
                RDFNode node = map.get(varName);
                if (node == null) continue;
                result.add(Var.alloc((String)varName), node.asNode());
            }
            return result;
        }
        return null;
    }

    public static QuerySolutionMap asQuerySolutionMap(Binding binding) {
        QuerySolutionMap map = new QuerySolutionMap();
        Iterator vars = binding.vars();
        while (vars.hasNext()) {
            Var var = (Var)vars.next();
            Node node = binding.get(var);
            if (node == null) continue;
            map.add(var.getName(), dummyModel.asRDFNode(node));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Resource> getAllTransitiveSubjects(Resource object, Property predicate, ProgressMonitor monitor) {
        HashSet<Resource> set = new HashSet<Resource>();
        helper.setGraphReadOptimization(true);
        try {
            JenaUtil.addTransitiveSubjects(set, object, predicate, monitor);
        }
        finally {
            helper.setGraphReadOptimization(false);
        }
        set.remove(object);
        return set;
    }

    public static Property asProperty(Resource resource) {
        if (resource instanceof Property) {
            return (Property)resource;
        }
        return new PropertyImpl(resource.asNode(), (EnhGraph)resource.getModel());
    }

    public static void collectBaseGraphs(Graph graph, Set<Graph> baseGraphs) {
        if (graph instanceof MultiUnion) {
            MultiUnion union = (MultiUnion)graph;
            JenaUtil.collectBaseGraphs(union.getBaseGraph(), baseGraphs);
            for (Object subGraph : union.getSubGraphs()) {
                JenaUtil.collectBaseGraphs((Graph)subGraph, baseGraphs);
            }
        } else if (graph != null) {
            baseGraphs.add(graph);
        }
    }

    public static Graph createDefaultGraph() {
        return helper.createDefaultGraph();
    }

    public static Model createDefaultModel() {
        Model m = ModelFactory.createModelForGraph((Graph)JenaUtil.createDefaultGraph());
        JenaUtil.initNamespaces((PrefixMapping)m);
        return m;
    }

    public static Graph createMemoryGraph() {
        return Factory.createDefaultGraph();
    }

    public static Model createMemoryModel() {
        return ModelFactory.createModelForGraph((Graph)JenaUtil.createMemoryGraph());
    }

    public static MultiUnion createMultiUnion() {
        return helper.createMultiUnion();
    }

    public static MultiUnion createMultiUnion(Graph[] graphs) {
        return helper.createMultiUnion(graphs);
    }

    public static MultiUnion createMultiUnion(Iterator<Graph> graphs) {
        return helper.createMultiUnion(graphs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Resource> getAllInstances(Resource cls) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            Model model = cls.getModel();
            Set<Resource> classes = JenaUtil.getAllSubClasses(cls);
            classes.add(cls);
            HashSet<Resource> results = new HashSet<Resource>();
            for (Resource subClass : classes) {
                StmtIterator it = model.listStatements(null, RDF.type, (RDFNode)subClass);
                while (it.hasNext()) {
                    results.add(((Statement)it.next()).getSubject());
                }
            }
            HashSet<Resource> hashSet = results;
            return hashSet;
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    public static Set<Resource> getAllSubClasses(Resource cls) {
        return JenaUtil.getAllTransitiveSubjects(cls, RDFS.subClassOf);
    }

    public static Set<Resource> getAllSubClassesStar(Resource cls) {
        Set<Resource> results = JenaUtil.getAllTransitiveSubjects(cls, RDFS.subClassOf);
        results.add(cls);
        return results;
    }

    public static Set<Resource> getAllSubProperties(Property superProperty) {
        return JenaUtil.getAllTransitiveSubjects((Resource)superProperty, RDFS.subPropertyOf);
    }

    public static Set<Resource> getAllSuperClasses(Resource cls) {
        return JenaUtil.getAllTransitiveObjects(cls, RDFS.subClassOf);
    }

    public static Set<Resource> getAllSuperClassesStar(Resource cls) {
        Set<Resource> results = JenaUtil.getAllTransitiveObjects(cls, RDFS.subClassOf);
        results.add(cls);
        return results;
    }

    public static Set<Resource> getAllSuperProperties(Property subProperty) {
        return JenaUtil.getAllTransitiveObjects((Resource)subProperty, RDFS.subPropertyOf);
    }

    public static Set<Resource> getAllTransitiveObjects(Resource subject, Property predicate) {
        HashSet<Resource> set = new HashSet<Resource>();
        JenaUtil.addTransitiveObjects(set, subject, predicate);
        set.remove(subject);
        return set;
    }

    private static Set<Resource> getAllTransitiveSubjects(Resource object, Property predicate) {
        return JenaUtil.getAllTransitiveSubjects(object, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Resource> getAllTypes(Resource instance) {
        HashSet<Resource> types = new HashSet<Resource>();
        try (StmtIterator it = instance.listProperties(RDF.type);){
            while (it.hasNext()) {
                Resource type = ((Statement)it.next()).getResource();
                types.add(type);
                types.addAll(JenaUtil.getAllSuperClasses(type));
            }
        }
        return types;
    }

    public static Graph getBaseGraph(Model model) {
        return JenaUtil.getBaseGraph(model.getGraph());
    }

    public static Graph getBaseGraph(Graph graph) {
        Graph baseGraph = graph;
        while (baseGraph instanceof MultiUnion) {
            baseGraph = ((MultiUnion)baseGraph).getBaseGraph();
        }
        return baseGraph;
    }

    public static Model getBaseModel(Model model) {
        Graph baseGraph = JenaUtil.getBaseGraph(model);
        if (baseGraph == model.getGraph()) {
            return model;
        }
        return ModelFactory.createModelForGraph((Graph)baseGraph);
    }

    public static Resource getFirstDirectRange(Resource property) {
        return property.getPropertyResourceValue(RDFS.range);
    }

    private static Resource getFirstRange(Resource property, Set<Resource> reached) {
        Resource directRange = JenaUtil.getFirstDirectRange(property);
        if (directRange != null) {
            return directRange;
        }
        StmtIterator it = property.listProperties(RDFS.subPropertyOf);
        while (it.hasNext()) {
            Resource superProperty;
            Statement ss = (Statement)it.next();
            if (!ss.getObject().isURIResource() || reached.contains(superProperty = ss.getResource())) continue;
            reached.add(superProperty);
            Resource r = JenaUtil.getFirstRange(superProperty, reached);
            if (r == null) continue;
            it.close();
            return r;
        }
        return null;
    }

    public static Resource getFirstRange(Resource property) {
        return JenaUtil.getFirstRange(property, new HashSet<Resource>());
    }

    public static Set<Resource> getImports(Resource graph) {
        HashSet<Resource> results = new HashSet<Resource>();
        for (Property importProperty : ImportProperties.get().getImportProperties()) {
            results.addAll(JenaUtil.getResourceProperties(graph, importProperty));
        }
        return results;
    }

    public static Integer getIntegerProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getInt();
        }
        return null;
    }

    public static RDFList getListProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().canAs(RDFList.class)) {
            return (RDFList)s.getResource().as(RDFList.class);
        }
        return null;
    }

    public static List<Literal> getLiteralProperties(Resource subject, Property predicate) {
        LinkedList<Literal> results = new LinkedList<Literal>();
        StmtIterator it = subject.listProperties(predicate);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isLiteral()) continue;
            results.add(s.getLiteral());
        }
        return results;
    }

    public static <T> T getNearest(Resource cls, Function<Resource, T> function) {
        T result = function.apply(cls);
        if (result != null) {
            return result;
        }
        return JenaUtil.getNearest(cls, function, new HashSet<Resource>());
    }

    private static <T> T getNearest(Resource cls, Function<Resource, T> function, Set<Resource> reached) {
        reached.add(cls);
        StmtIterator it = cls.listProperties(RDFS.subClassOf);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isResource() || reached.contains(s.getResource())) continue;
            T result = function.apply(s.getResource());
            if (result == null) {
                result = JenaUtil.getNearest(s.getResource(), function, reached);
            }
            if (result == null) continue;
            it.close();
            return result;
        }
        return null;
    }

    public static String getNsPrefixURI(Model model, String prefix) {
        if ("".equals(prefix) && model.getGraph() instanceof MultiUnion) {
            Graph baseGraph = ((MultiUnion)model.getGraph()).getBaseGraph();
            if (baseGraph != null) {
                return baseGraph.getPrefixMapping().getNsPrefixURI(prefix);
            }
            return model.getNsPrefixURI(prefix);
        }
        return model.getNsPrefixURI(prefix);
    }

    public static RDFNode getProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null) {
            return s.getObject();
        }
        return null;
    }

    public static Resource getResourceProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isResource()) {
            return s.getResource();
        }
        return null;
    }

    public static Resource getResourcePropertyWithType(Resource subject, Property predicate, Resource type) {
        StmtIterator it = subject.listProperties(predicate);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isResource() || !JenaUtil.hasIndirectType(s.getResource(), type)) continue;
            it.close();
            return s.getResource();
        }
        return null;
    }

    public static List<Resource> getResourceProperties(Resource subject, Property predicate) {
        LinkedList<Resource> results = new LinkedList<Resource>();
        StmtIterator it = subject.listProperties(predicate);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isResource()) continue;
            results.add(s.getResource());
        }
        return results;
    }

    public static Resource getURIResourceProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isURIResource()) {
            return s.getResource();
        }
        return null;
    }

    public static List<Resource> getURIResourceProperties(Resource subject, Property predicate) {
        LinkedList<Resource> results = new LinkedList<Resource>();
        StmtIterator it = subject.listProperties(predicate);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isURIResource()) continue;
            results.add(s.getResource());
        }
        return results;
    }

    public static String getStringProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getString();
        }
        return null;
    }

    public static boolean getBooleanProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getBoolean();
        }
        return false;
    }

    public static Double getDoubleProperty(Resource subject, Property predicate) {
        Statement s = subject.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getDouble();
        }
        return null;
    }

    public static double getDoubleProperty(Resource subject, Property predicate, double defaultValue) {
        Double d = JenaUtil.getDoubleProperty(subject, predicate);
        if (d != null) {
            return d;
        }
        return defaultValue;
    }

    public static List<Graph> getSubGraphs(MultiUnion union) {
        LinkedList<Graph> results = new LinkedList<Graph>();
        results.add(union.getBaseGraph());
        results.addAll(union.getSubGraphs());
        return results;
    }

    public static Collection<Resource> getSuperClasses(Resource subClass) {
        NodeIterator it = subClass.getModel().listObjectsOfProperty(subClass, RDFS.subClassOf);
        HashSet<Resource> results = new HashSet<Resource>();
        while (it.hasNext()) {
            RDFNode node = it.nextNode();
            if (!(node instanceof Resource)) continue;
            results.add((Resource)node);
        }
        return results;
    }

    public static Resource getType(Resource instance) {
        return JenaUtil.getResourceProperty(instance, RDF.type);
    }

    public static List<Resource> getTypes(Resource instance) {
        return JenaUtil.getResourceProperties(instance, RDF.type);
    }

    public static boolean hasIndirectType(Resource instance, Resource expectedType) {
        if (expectedType.getModel() == null) {
            expectedType = expectedType.inModel(instance.getModel());
        }
        StmtIterator it = instance.listProperties(RDF.type);
        while (it.hasNext()) {
            Resource actualType;
            Statement s = (Statement)it.next();
            if (!s.getObject().isResource() || !(actualType = s.getResource()).equals((Object)expectedType) && !JenaUtil.hasSuperClass(actualType, expectedType)) continue;
            it.close();
            return true;
        }
        return false;
    }

    public static boolean hasSuperClass(Resource subClass, Resource superClass) {
        return JenaUtil.hasSuperClass(subClass, superClass, new HashSet<Resource>());
    }

    private static boolean hasSuperClass(Resource subClass, Resource superClass, Set<Resource> reached) {
        StmtIterator it = subClass.listProperties(RDFS.subClassOf);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (superClass.equals((Object)s.getObject())) {
                it.close();
                return true;
            }
            if (reached.contains(s.getResource())) continue;
            reached.add(s.getResource());
            if (!JenaUtil.hasSuperClass(s.getResource(), superClass, reached)) continue;
            it.close();
            return true;
        }
        return false;
    }

    public static boolean hasSuperProperty(Property subProperty, Property superProperty) {
        return JenaUtil.getAllSuperProperties(subProperty).contains(superProperty);
    }

    public static void initNamespaces(Graph graph) {
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        JenaUtil.initNamespaces(prefixMapping);
    }

    public static void initNamespaces(PrefixMapping prefixMapping) {
        JenaUtil.ensurePrefix(prefixMapping, "rdf", RDF.getURI());
        JenaUtil.ensurePrefix(prefixMapping, "rdfs", RDFS.getURI());
        JenaUtil.ensurePrefix(prefixMapping, "owl", OWL.getURI());
        JenaUtil.ensurePrefix(prefixMapping, "xsd", XSD.getURI());
    }

    private static void ensurePrefix(PrefixMapping prefixMapping, String prefix, String uristr) {
        if (!uristr.equals(prefixMapping.getNsPrefixURI(prefix))) {
            prefixMapping.setNsPrefix(prefix, uristr);
        }
    }

    public static boolean isMemoryGraph(Graph graph) {
        if (graph instanceof MultiUnion) {
            for (Graph subGraph : JenaUtil.getSubGraphs((MultiUnion)graph)) {
                if (JenaUtil.isMemoryGraph(subGraph)) continue;
                return false;
            }
            return true;
        }
        return helper.isMemoryGraph(graph);
    }

    public static StmtIterator listAllProperties(Resource subject, Property predicate) {
        LinkedList<Statement> results = new LinkedList<Statement>();
        helper.setGraphReadOptimization(true);
        try {
            JenaUtil.listAllProperties(subject, predicate, new HashSet<Property>(), results);
        }
        finally {
            helper.setGraphReadOptimization(false);
        }
        return new StmtIteratorImpl(results.iterator());
    }

    private static void listAllProperties(Resource subject, Property predicate, Set<Property> reached, List<Statement> results) {
        Model model;
        StmtIterator sit;
        reached.add(predicate);
        if (subject != null) {
            sit = subject.listProperties(predicate);
            model = subject.getModel();
        } else {
            model = predicate.getModel();
            sit = model.listStatements(null, predicate, (RDFNode)null);
        }
        while (sit.hasNext()) {
            results.add((Statement)sit.next());
        }
        StmtIterator it = model.listStatements(null, RDFS.subPropertyOf, (RDFNode)predicate);
        while (it.hasNext()) {
            Statement sps = (Statement)it.next();
            if (reached.contains(sps.getSubject())) continue;
            Property subProperty = JenaUtil.asProperty(sps.getSubject());
            JenaUtil.listAllProperties(subject, subProperty, reached, results);
        }
    }

    public static Model asReadOnlyModel(Model m) {
        return helper.asReadOnlyModel(m);
    }

    public static Graph asReadOnlyGraph(Graph g) {
        return helper.asReadOnlyGraph(g);
    }

    public static OntModel createOntologyModel(OntModelSpec spec, Model base) {
        return helper.createOntologyModel(spec, base);
    }

    public static void setGraphReadOptimization(boolean onOrOff) {
        helper.setGraphReadOptimization(onOrOff);
    }

    public static Graph deepCloneForReadOnlyThreadSafe(Graph g) {
        return helper.deepCloneReadOnlyGraph(g);
    }

    public static Node invokeExpression(String expression, QuerySolution initialBinding, Dataset dataset) {
        if (dataset == null) {
            dataset = ARQFactory.get().getDataset(ModelFactory.createDefaultModel());
        }
        Query query = ARQFactory.get().createExpressionQuery(expression);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, dataset, initialBinding);){
            String firstVarName;
            QuerySolution qs;
            RDFNode rdfNode;
            ResultSet rs = qexec.execSelect();
            Node result = null;
            if (rs.hasNext() && (rdfNode = (qs = rs.next()).get(firstVarName = (String)rs.getResultVars().get(0))) != null) {
                result = rdfNode.asNode();
            }
            Node node = result;
            return node;
        }
    }

    public static Node invokeFunction0(Resource function, Dataset dataset) {
        String expression = "<" + function + ">()";
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        return JenaUtil.invokeExpression(expression, (QuerySolution)initialBinding, dataset);
    }

    public static Node invokeFunction1(Resource function, RDFNode argument, Dataset dataset) {
        String expression = "<" + function + ">(?arg1)";
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("arg1", argument);
        return JenaUtil.invokeExpression(expression, (QuerySolution)initialBinding, dataset);
    }

    public static Node invokeFunction1(Resource function, Node argument, Dataset dataset) {
        return JenaUtil.invokeFunction1(function, JenaUtil.toRDFNode(argument), dataset);
    }

    public static Node invokeFunction2(Resource function, RDFNode argument1, RDFNode argument2, Dataset dataset) {
        String expression = "<" + function + ">(?arg1, ?arg2)";
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        if (argument1 != null) {
            initialBinding.add("arg1", argument1);
        }
        if (argument2 != null) {
            initialBinding.add("arg2", argument2);
        }
        return JenaUtil.invokeExpression(expression, (QuerySolution)initialBinding, dataset);
    }

    public static Node invokeFunction2(Resource function, Node argument1, Node argument2, Dataset dataset) {
        return JenaUtil.invokeFunction2(function, JenaUtil.toRDFNode(argument1), JenaUtil.toRDFNode(argument2), dataset);
    }

    public static Node invokeFunction3(Resource function, RDFNode argument1, RDFNode argument2, RDFNode argument3, Dataset dataset) {
        String expression = "<" + function + ">(?arg1, ?arg2, ?arg3)";
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("arg1", argument1);
        if (argument2 != null) {
            initialBinding.add("arg2", argument2);
        }
        if (argument3 != null) {
            initialBinding.add("arg3", argument3);
        }
        return JenaUtil.invokeExpression(expression, (QuerySolution)initialBinding, dataset);
    }

    public static Node invokeFunction3(Resource function, Node argument1, Node argument2, Node argument3, Dataset dataset) {
        return JenaUtil.invokeFunction3(function, JenaUtil.toRDFNode(argument1), JenaUtil.toRDFNode(argument2), JenaUtil.toRDFNode(argument3), dataset);
    }

    public static Query queryWithSubstitutions(Query query, final Map<Var, Node> substitutions) {
        Query result = QueryTransformOps.transform((Query)query, substitutions);
        if (result.hasHaving()) {
            NodeTransform nodeTransform = new NodeTransform(){

                public Node apply(Node node) {
                    Node n = (Node)substitutions.get(node);
                    if (n == null) {
                        return node;
                    }
                    return n;
                }
            };
            ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
            ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, (ElementTransform)eltrans);
            List havingExprs = result.getHavingExprs();
            for (int i = 0; i < havingExprs.size(); ++i) {
                Expr old = (Expr)havingExprs.get(i);
                Expr neo = ExprTransformer.transform((ExprTransform)exprTrans, (Expr)old);
                if (neo == old) continue;
                havingExprs.set(i, neo);
            }
        }
        return result;
    }

    public static void sort(List<Resource> nodes) {
        Collections.sort(nodes, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return NodeUtils.compareRDFTerms((Node)o1.asNode(), (Node)o2.asNode());
            }
        });
    }

    public static RDFNode toRDFNode(Node node) {
        if (node != null) {
            return dummyModel.asRDFNode(node);
        }
        return null;
    }

    public static String withImports(String uri) {
        if (!uri.startsWith(WITH_IMPORTS_PREFIX)) {
            return WITH_IMPORTS_PREFIX + uri;
        }
        return uri;
    }

    public static String withoutImports(String uri) {
        if (uri.startsWith(WITH_IMPORTS_PREFIX)) {
            return uri.substring(WITH_IMPORTS_PREFIX.length());
        }
        return uri;
    }
}

