/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.Map;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaUtil;

public class RDFLabels {
    private static RDFLabels singleton = new RDFLabels();

    public static RDFLabels get() {
        return singleton;
    }

    public static void set(RDFLabels value) {
        singleton = value;
    }

    public String getCustomizedLabel(Resource resource) {
        String label = JenaUtil.getStringProperty(resource, RDFS.label);
        if (label != null) {
            return label;
        }
        return this.getLabel(resource);
    }

    public String getLabel(Resource resource) {
        if (resource.isURIResource() && resource.getModel() != null) {
            String qname = resource.getModel().qnameFor(resource.getURI());
            if (qname != null) {
                return qname;
            }
            return "<" + resource.getURI() + ">";
        }
        if (resource.isAnon() && resource.getModel() != null && resource.hasProperty(RDF.first)) {
            StringBuffer buffer = new StringBuffer("[");
            ExtendedIterator members = ((RDFList)resource.as(RDFList.class)).iterator();
            while (members.hasNext()) {
                RDFNode member = (RDFNode)members.next();
                buffer.append(RDFLabels.get().getNodeLabel(member));
                if (!members.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            return buffer.toString();
        }
        return resource.toString();
    }

    public String getNodeLabel(RDFNode node) {
        if (node.isLiteral()) {
            return node.asNode().getLiteralLexicalForm();
        }
        return this.getLabel((Resource)node);
    }

    public static void appendTemplateCallLabel(StringBuffer buffer, String labelTemplate, Map<String, RDFNode> args) {
        for (int i = 0; i < labelTemplate.length(); ++i) {
            if (i < labelTemplate.length() - 3 && labelTemplate.charAt(i) == '{' && labelTemplate.charAt(i + 1) == '?') {
                int varEnd;
                for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                    if (labelTemplate.charAt(varEnd) != '}') continue;
                    String varName = labelTemplate.substring(i + 2, varEnd);
                    RDFNode varValue = args.get(varName);
                    if (varValue instanceof Resource) {
                        buffer.append(RDFLabels.get().getLabel((Resource)varValue));
                        break;
                    }
                    if (!(varValue instanceof Literal)) break;
                    buffer.append(varValue.asNode().getLiteralLexicalForm());
                    break;
                }
                i = varEnd;
                continue;
            }
            buffer.append(labelTemplate.charAt(i));
        }
    }
}

