/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLRule
extends Rule {
    private Query query;

    public SPARQLRule(Resource rule) {
        super(rule);
        String rawString = JenaUtil.getStringProperty(rule, SH.construct);
        String queryString = SPARQLSubstitutions.withPrefixes(rawString, rule);
        this.query = ARQFactory.get().createQuery(queryString);
        if (!this.query.isConstructType()) {
            throw new IllegalArgumentException("Values of sh:construct must be CONSTRUCT queries");
        }
    }

    @Override
    public void execute(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        ProgressMonitor monitor = ruleEngine.getProgressMonitor();
        for (RDFNode focusNode : focusNodes) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add(SH.thisVar.getVarName(), focusNode);
            QueryExecution qexec = ARQFactory.get().createQueryExecution(this.query, ruleEngine.getDataset(), (QuerySolution)bindings);
            Throwable throwable = null;
            try {
                Model constructed = qexec.execConstruct();
                for (Statement s : constructed.listStatements().toList()) {
                    ruleEngine.infer(s.asTriple(), this, shape);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (qexec == null) continue;
                if (throwable != null) {
                    try {
                        qexec.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                qexec.close();
            }
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        String label = this.getLabel();
        if (label == null) {
            Statement s = this.getResource().getProperty(SH.construct);
            label = s != null && s.getObject().isLiteral() ? "\n" + s.getString() : "(Missing SPARQL query)";
        }
        return this.getLabelStart("SPARQL") + label;
    }
}

