/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.vocabulary.SH;

public class PrefixUtil {
    public static Resource addNamespace(Resource ontology, String prefix, String namespace) {
        Resource declaration = ontology.getModel().createResource(namespace + SH.PrefixDeclaration.getLocalName(), SH.PrefixDeclaration);
        ontology.addProperty(SH.declare, (RDFNode)declaration);
        declaration.addProperty(SH.prefix, prefix);
        declaration.addProperty(SH.namespace, (RDFNode)ResourceFactory.createTypedLiteral((String)namespace, (RDFDatatype)TypeMapper.getInstance().getSafeTypeByName(XSD.anyURI.getURI())));
        return declaration;
    }

    public static String getImportedNamespace(Resource ontology, String prefix) {
        return PrefixUtil.getImportedNamespace(ontology, prefix, new HashSet<Resource>());
    }

    private static String getImportedNamespace(Resource ontology, String prefix, Set<Resource> reached) {
        reached.add(ontology);
        for (Resource imp : JenaUtil.getResourceProperties(ontology, OWL.imports)) {
            if (reached.contains(imp)) continue;
            String ns = PrefixUtil.getNamespace(imp, prefix);
            if (ns == null) {
                ns = PrefixUtil.getImportedNamespace(imp, prefix, reached);
            }
            if (ns == null) continue;
            return ns;
        }
        return null;
    }

    public static String getNamespace(Resource ontology, String prefix) {
        for (Resource declaration : JenaUtil.getResourceProperties(ontology, SH.declare)) {
            if (!declaration.hasProperty(SH.prefix, prefix)) continue;
            return JenaUtil.getStringProperty(declaration, SH.namespace);
        }
        return null;
    }
}

