/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.AbstractEngine;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.util.FailureLog;
import org.topbraid.shacl.util.SHACLPreferences;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ValidationEngine
extends AbstractEngine {
    private Predicate<RDFNode> focusNodeFilter;
    private Function<RDFNode, String> labelFunction = node -> node.toString();
    private Resource report;

    protected ValidationEngine(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, Resource report) {
        super(dataset, shapesGraph, shapesGraphURI);
        if (report == null) {
            Model reportModel = JenaUtil.createMemoryModel();
            reportModel.setNsPrefixes((PrefixMapping)dataset.getDefaultModel());
            this.report = reportModel.createResource(SH.ValidationReport);
        } else {
            this.report = report;
        }
    }

    public Function<RDFNode, String> getLabelFunction() {
        return this.labelFunction;
    }

    public void setLabelFunction(Function<RDFNode, String> value) {
        this.labelFunction = value;
    }

    public void addResultMessage(Resource result, Literal message, QuerySolution bindings) {
        result.addProperty(SH.resultMessage, (RDFNode)SPARQLSubstitutions.withSubstitutions(message, bindings, this.getLabelFunction()));
    }

    public Resource createResult(Resource type, Constraint constraint, RDFNode focusNode) {
        Resource result = this.report.getModel().createResource(type);
        this.report.addProperty(SH.result, (RDFNode)result);
        result.addProperty(SH.resultSeverity, (RDFNode)constraint.getShapeResource().getSeverity());
        result.addProperty(SH.sourceConstraintComponent, (RDFNode)constraint.getComponent());
        result.addProperty(SH.sourceShape, (RDFNode)constraint.getShapeResource());
        if (focusNode != null) {
            result.addProperty(SH.focusNode, focusNode);
        }
        return result;
    }

    public Resource getReport() {
        return this.report;
    }

    private Set<Resource> getShapesForNode(RDFNode focusNode, Dataset dataset, Model shapesModel) {
        HashSet<Resource> shapes = new HashSet<Resource>();
        shapes.addAll(shapesModel.listSubjectsWithProperty(SH.targetNode, focusNode).toList());
        if (focusNode instanceof Resource) {
            for (Statement s : shapesModel.listStatements(null, SH.targetSubjectsOf, (RDFNode)null).toList()) {
                if (!((Resource)focusNode).hasProperty(JenaUtil.asProperty(s.getResource()))) continue;
                shapes.add(s.getSubject());
            }
        }
        for (Statement s : shapesModel.listStatements(null, SH.targetObjectsOf, (RDFNode)null).toList()) {
            if (!focusNode.getModel().contains(null, JenaUtil.asProperty(s.getResource()), focusNode)) continue;
            shapes.add(s.getSubject());
        }
        if (focusNode instanceof Resource) {
            for (Resource type : JenaUtil.getAllTypes((Resource)focusNode)) {
                if (JenaUtil.hasIndirectType(type.inModel(shapesModel), SH.Shape)) {
                    shapes.add(type);
                }
                for (Statement s : shapesModel.listStatements(null, SH.targetClass, (RDFNode)type).toList()) {
                    shapes.add(s.getSubject());
                }
            }
        }
        for (Statement s : shapesModel.listStatements(null, SH.target, (RDFNode)null).toList()) {
            if (!SHACLUtil.isInTarget(focusNode, dataset, s.getResource())) continue;
            shapes.add(s.getSubject());
        }
        return shapes;
    }

    public List<RDFNode> getValueNodes(Constraint constraint, RDFNode focusNode) {
        Resource path = JenaUtil.getResourceProperty(constraint.getShapeResource(), SH.path);
        if (path == null) {
            return Collections.singletonList(focusNode);
        }
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        Path jenaPath = constraint.getShape().getJenaPath();
        if (jenaPath != null) {
            SHACLPaths.addValueNodes(focusNode, jenaPath, results);
        } else {
            SHACLPaths.addValueNodes(focusNode, JenaUtil.asProperty(path), results);
        }
        return results;
    }

    public void setFocusNodeFilter(Predicate<RDFNode> value) {
        this.focusNodeFilter = value;
    }

    public void updateConforms() {
        boolean conforms = true;
        StmtIterator it = this.report.listProperties(SH.result);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getResource().hasProperty(RDF.type, (RDFNode)SH.ValidationResult)) continue;
            conforms = false;
            it.close();
            break;
        }
        this.report.removeAll(SH.conforms);
        this.report.addProperty(SH.conforms, (RDFNode)(conforms ? JenaDatatypes.TRUE : JenaDatatypes.FALSE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateAll() throws InterruptedException {
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            List<Shape> rootShapes = this.shapesGraph.getRootShapes();
            if (this.monitor != null) {
                this.monitor.beginTask("Validating " + rootShapes.size() + " shapes", rootShapes.size());
            }
            int i = 0;
            for (Shape shape : rootShapes) {
                if (this.monitor != null) {
                    this.monitor.subTask("Shape " + ++i + ": " + this.getLabelFunction().apply((RDFNode)shape.getShapeResource()));
                }
                List<RDFNode> focusNodes = SHACLUtil.getTargetNodes(shape.getShapeResource(), this.dataset);
                if (this.focusNodeFilter != null) {
                    LinkedList<RDFNode> filteredFocusNodes = new LinkedList<RDFNode>();
                    for (RDFNode focusNode : focusNodes) {
                        if (!this.focusNodeFilter.test(focusNode)) continue;
                        filteredFocusNodes.add(focusNode);
                    }
                    focusNodes = filteredFocusNodes;
                }
                if (!(focusNodes.isEmpty() || this.shapesGraph.isIgnored(shape.getShapeResource().asNode()) || shape.getShapeResource().isDeactivated())) {
                    for (Constraint constraint : shape.getConstraints()) {
                        this.validateNodesAgainstConstraint(focusNodes, constraint);
                    }
                }
                if (this.monitor == null) continue;
                this.monitor.worked(1);
                if (!this.monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        this.updateConforms();
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNode(Node focusNode) throws InterruptedException {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        RDFNode focusRDFNode = this.dataset.getDefaultModel().asRDFNode(focusNode);
        Set<Resource> shapes = this.getShapesForNode(focusRDFNode, this.dataset, shapesModel);
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            for (Resource shape : shapes) {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.validateNodesAgainstShape(Collections.singletonList(focusRDFNode), shape.asNode());
            }
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNodesAgainstShape(List<RDFNode> focusNodes, Node shape) {
        Shape vs;
        if (!this.shapesGraph.isIgnored(shape) && !(vs = this.shapesGraph.getShape(shape)).getShapeResource().isDeactivated()) {
            boolean nested = SHACLScriptEngineManager.begin();
            try {
                for (Constraint constraint : vs.getConstraints()) {
                    this.validateNodesAgainstConstraint(focusNodes, constraint);
                }
            }
            finally {
                SHACLScriptEngineManager.end(nested);
            }
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodesConformToShape(List<RDFNode> focusNodes, Node shape) {
        block11: {
            if (!this.shapesGraph.isIgnored(shape)) {
                Resource oldReport = this.report;
                this.report = JenaUtil.createMemoryModel().createResource();
                try {
                    Shape vs = this.shapesGraph.getShape(shape);
                    if (vs.getShapeResource().isDeactivated()) break block11;
                    boolean nested = SHACLScriptEngineManager.begin();
                    try {
                        Iterator<Constraint> iterator = vs.getConstraints().iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                Constraint constraint = iterator.next();
                                this.validateNodesAgainstConstraint(focusNodes, constraint);
                                if (!this.report.hasProperty(SH.result)) continue;
                                boolean bl = false;
                                return bl;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        SHACLScriptEngineManager.end(nested);
                    }
                }
                finally {
                    this.report = oldReport;
                }
            }
        }
        return true;
    }

    private void validateNodesAgainstConstraint(List<RDFNode> focusNodes, Constraint constraint) {
        ConstraintExecutor executor = constraint.getExecutor();
        if (executor != null) {
            if (SHACLPreferences.isProduceFailuresMode()) {
                try {
                    executor.executeConstraint(constraint, this, focusNodes);
                }
                catch (Exception ex) {
                    Resource result = this.createResult(DASH.FailureResult, constraint, null);
                    result.addProperty(SH.resultMessage, "Exception during validation: " + ExceptionUtil.getStackTrace(ex));
                }
            } else {
                executor.executeConstraint(constraint, this, focusNodes);
            }
        } else {
            FailureLog.get().logFailure("No suitable validator found for constraint " + constraint);
        }
    }
}

