/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.HashSet;
import java.util.List;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHSPARQLConstraint;
import org.topbraid.shacl.validation.SHACLException;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.sparql.AbstractSPARQLExecutor;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.validation.sparql.SPARQLSyntaxChecker;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLConstraintExecutor
extends AbstractSPARQLExecutor {
    public SPARQLConstraintExecutor(Constraint constraint) {
        super(constraint);
        HashSet<String> preBoundVars = new HashSet<String>();
        preBoundVars.add(SH.thisVar.getVarName());
        preBoundVars.add(SH.shapesGraphVar.getVarName());
        preBoundVars.add(SH.currentShapeVar.getVarName());
        List<String> errors = SPARQLSyntaxChecker.checkQuery(this.getQuery(), preBoundVars);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.size() + " violations of SPARQL Syntax rules (Appendix A): " + errors + ". Query: " + this.getQuery());
        }
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, List<RDFNode> focusNodes) {
        if (((Resource)constraint.getParameterValue()).hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) {
            return;
        }
        super.executeConstraint(constraint, engine, focusNodes);
    }

    @Override
    protected void addBindings(Constraint constraint, QuerySolutionMap bindings) {
    }

    @Override
    protected String getLabel(Constraint constraint) {
        return "SPARQL Constraint " + JenaUtil.getStringProperty((Resource)constraint.getParameterValue(), SH.select);
    }

    @Override
    protected String getSPARQL(Constraint constraint) {
        SHSPARQLConstraint sc = SHFactory.asSPARQLConstraint(constraint.getParameterValue());
        String select = JenaUtil.getStringProperty(sc, SH.select);
        if (select == null) {
            StmtIterator it;
            String message = "Missing sh:" + SH.select.getLocalName() + " of " + RDFLabels.get().getLabel(sc);
            if (sc.isAnon() && (it = sc.getModel().listStatements(null, null, (RDFNode)sc)).hasNext()) {
                Statement s = (Statement)it.next();
                it.close();
                message = message + " at " + RDFLabels.get().getLabel(s.getSubject());
                message = message + " via " + RDFLabels.get().getLabel((Resource)s.getPredicate());
            }
            throw new SHACLException(message);
        }
        return SPARQLSubstitutions.withPrefixes(select, sc);
    }

    @Override
    protected Resource getSPARQLExecutable(Constraint constraint) {
        return (Resource)constraint.getParameterValue();
    }
}

