/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.HashSet;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.validation.SHACLException;
import org.topbraid.shacl.validation.TargetPlugin;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLTargetPlugin
implements TargetPlugin {
    @Override
    public boolean canExecuteTarget(Resource target) {
        return target.hasProperty(SH.select);
    }

    @Override
    public Iterable<RDFNode> executeTarget(Dataset dataset, Resource target, SHParameterizableTarget parameterizableTarget) {
        Query query;
        String sparql = JenaUtil.getStringProperty(target, SH.select);
        String queryString = SPARQLSubstitutions.withPrefixes(sparql, target);
        try {
            query = SPARQLTargetPlugin.getSPARQLWithSelect(target);
        }
        catch (QueryParseException ex) {
            throw new SHACLException("Invalid SPARQL target (" + ex.getLocalizedMessage() + "):\n" + queryString);
        }
        QuerySolutionMap bindings = null;
        if (parameterizableTarget != null) {
            bindings = new QuerySolutionMap();
            parameterizableTarget.addBindings(bindings);
        }
        try (QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query, dataset, (QuerySolution)bindings);){
            HashSet<RDFNode> results = new HashSet<RDFNode>();
            ResultSet rs = qexec.execSelect();
            List varNames = rs.getResultVars();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                for (String varName : varNames) {
                    RDFNode value = qs.get(varName);
                    if (value == null) continue;
                    results.add(value);
                }
            }
            HashSet<RDFNode> hashSet = results;
            return hashSet;
        }
    }

    @Override
    public boolean isNodeInTarget(RDFNode focusNode, Dataset dataset, Resource executable, SHParameterizableTarget parameterizableTarget) {
        Query query;
        String ask = JenaUtil.getStringProperty(executable, SH.ask);
        if (ask != null) {
            Query query2;
            String queryString = SPARQLSubstitutions.withPrefixes(ask, executable);
            try {
                query2 = ARQFactory.get().createQuery(queryString);
            }
            catch (QueryParseException ex) {
                throw new SHACLException("Invalid SPARQL target (" + ex.getLocalizedMessage() + "):\n" + queryString);
            }
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add(SH.thisVar.getVarName(), focusNode);
            if (parameterizableTarget != null) {
                parameterizableTarget.addBindings(bindings);
            }
            try (QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query2, dataset, (QuerySolution)bindings);){
                boolean bl = qexec.execAsk();
                return bl;
            }
        }
        String sparql = JenaUtil.getStringProperty(executable, SH.select);
        String queryString = SPARQLSubstitutions.withPrefixes(sparql, executable);
        try {
            query = ARQFactory.get().createQuery(queryString);
        }
        catch (QueryParseException ex) {
            throw new SHACLException("Invalid SPARQL target (" + ex.getLocalizedMessage() + "):\n" + queryString);
        }
        QuerySolutionMap bindings = new QuerySolutionMap();
        bindings.add(SH.thisVar.getVarName(), focusNode);
        if (parameterizableTarget != null) {
            parameterizableTarget.addBindings(bindings);
        }
        try (QueryExecution qexec = SPARQLSubstitutions.createQueryExecution(query, dataset, (QuerySolution)bindings);){
            boolean hasNext;
            ResultSet rs = qexec.execSelect();
            boolean bl = hasNext = rs.hasNext();
            return bl;
        }
    }

    private static Query getSPARQLWithSelect(Resource host) {
        String sparql = JenaUtil.getStringProperty(host, SH.select);
        if (sparql == null) {
            throw new SHACLException("Missing sh:sparql at " + host);
        }
        try {
            return ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(sparql, host));
        }
        catch (Exception ex) {
            return ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes("SELECT ?this WHERE {" + sparql + "}", host));
        }
    }
}

