/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.lib.AskExpression;
import org.topbraid.shacl.expr.lib.ConstantTermExpression;
import org.topbraid.shacl.expr.lib.CountExpression;
import org.topbraid.shacl.expr.lib.DistinctExpression;
import org.topbraid.shacl.expr.lib.ExistsExpression;
import org.topbraid.shacl.expr.lib.FilterShapeExpression;
import org.topbraid.shacl.expr.lib.FocusNodeExpression;
import org.topbraid.shacl.expr.lib.FunctionExpression;
import org.topbraid.shacl.expr.lib.GroupConcatExpression;
import org.topbraid.shacl.expr.lib.IfExpression;
import org.topbraid.shacl.expr.lib.IntersectionExpression;
import org.topbraid.shacl.expr.lib.LimitExpression;
import org.topbraid.shacl.expr.lib.MaxExpression;
import org.topbraid.shacl.expr.lib.MinExpression;
import org.topbraid.shacl.expr.lib.MinusExpression;
import org.topbraid.shacl.expr.lib.OffsetExpression;
import org.topbraid.shacl.expr.lib.OrderByExpression;
import org.topbraid.shacl.expr.lib.PathExpression;
import org.topbraid.shacl.expr.lib.SelectExpression;
import org.topbraid.shacl.expr.lib.SumExpression;
import org.topbraid.shacl.expr.lib.UnionExpression;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class NodeExpressionFactory {
    private static Map<Property, BiFunction<Resource, RDFNode, NodeExpression>> constructors = new HashMap<Property, BiFunction<Resource, RDFNode, NodeExpression>>();
    private static NodeExpressionFactory singleton;

    public static NodeExpressionFactory get() {
        return singleton;
    }

    public static void set(NodeExpressionFactory value) {
        singleton = value;
    }

    public void addPlugin(Property predicate, BiFunction<Resource, RDFNode, NodeExpression> function) {
        constructors.put(predicate, function);
    }

    public NodeExpression create(RDFNode node) {
        Statement s;
        if (SH.this_.equals((Object)node)) {
            return new FocusNodeExpression(node);
        }
        if (node.isURIResource() || node.isLiteral()) {
            return new ConstantTermExpression(node);
        }
        Resource resource = node.asResource();
        StmtIterator it = resource.listProperties();
        while (it.hasNext()) {
            NodeExpression expr;
            s = (Statement)it.next();
            BiFunction<Resource, RDFNode, NodeExpression> function = constructors.get(s.getPredicate());
            if (function == null || (expr = function.apply(resource, s.getObject())) == null) continue;
            it.close();
            return expr;
        }
        s = this.getFunctionStatement(resource);
        if (s != null) {
            LinkedList<NodeExpression> args = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)s.getResource().as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                args.add(this.create(member));
            }
            return new FunctionExpression((RDFNode)resource, (Resource)s.getPredicate(), args);
        }
        throw new IllegalArgumentException("Malformed SHACL node expression");
    }

    public Statement getFunctionStatement(Resource resource) {
        for (Statement sc : resource.listProperties().toList()) {
            if (!RDF.nil.equals((Object)sc.getObject()) && (!sc.getObject().isAnon() || !sc.getResource().hasProperty(RDF.first))) continue;
            return sc;
        }
        return null;
    }

    static {
        constructors.put(SH.ask, (resource, ask) -> {
            String queryString = ask.asNode().getLiteralLexicalForm();
            Query arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(queryString, resource));
            Statement nodesS = resource.getProperty(SH.nodes);
            NodeExpression input = nodesS != null ? NodeExpressionFactory.get().create(nodesS.getObject()) : null;
            return new AskExpression((Resource)resource, arqQuery, input, queryString);
        });
        constructors.put(SH.count, (resource, count) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)count);
            return new CountExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.distinct, (resource, distinct) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)distinct);
            return new DistinctExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.exists, (resource, exists) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)exists);
            return new ExistsExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.filterShape, (resource, filterShape) -> {
            if (filterShape instanceof Resource) {
                NodeExpression nodes = null;
                Statement nodesS = resource.getProperty(SH.nodes);
                if (nodesS != null) {
                    nodes = NodeExpressionFactory.get().create(nodesS.getObject());
                }
                return new FilterShapeExpression((RDFNode)resource, nodes, (Resource)filterShape);
            }
            return null;
        });
        constructors.put(SH.groupConcat, (resource, groupConcat) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)groupConcat);
            return new GroupConcatExpression((RDFNode)resource, nodes, JenaUtil.getStringProperty(resource, SH.separator));
        });
        constructors.put(SH.if_, (resource, if_) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)if_);
            Statement thenS = resource.getProperty(SH.then);
            NodeExpression then = thenS != null ? NodeExpressionFactory.get().create(thenS.getObject()) : null;
            Statement elseS = resource.getProperty(SH.else_);
            NodeExpression else_ = elseS != null ? NodeExpressionFactory.get().create(elseS.getObject()) : null;
            return new IfExpression((RDFNode)resource, nodes, then, else_);
        });
        constructors.put(SH.intersection, (resource, intersection) -> {
            LinkedList<NodeExpression> inputs = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)intersection.as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                inputs.add(NodeExpressionFactory.get().create(member));
            }
            return new IntersectionExpression((RDFNode)resource, inputs);
        });
        constructors.put(SH.limit, (resource, limit) -> {
            Statement nodesS = resource.getProperty(SH.nodes);
            if (nodesS != null && limit.isLiteral()) {
                NodeExpression nodes = NodeExpressionFactory.get().create(nodesS.getObject());
                int l = limit.asLiteral().getInt();
                return new LimitExpression((RDFNode)resource, nodes, l);
            }
            return null;
        });
        constructors.put(SH.max, (resource, max) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)max);
            return new MaxExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.min, (resource, min) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)min);
            return new MinExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.minus, (resource, minus) -> {
            Statement nodesS = resource.getProperty(SH.nodes);
            if (nodesS != null) {
                NodeExpression nodes = NodeExpressionFactory.get().create(nodesS.getObject());
                NodeExpression minusExpr = NodeExpressionFactory.get().create((RDFNode)minus);
                return new MinusExpression((RDFNode)resource, nodes, minusExpr);
            }
            return null;
        });
        constructors.put(SH.offset, (resource, offset) -> {
            Statement nodesS = resource.getProperty(SH.nodes);
            if (nodesS != null && offset.isLiteral()) {
                NodeExpression nodes = NodeExpressionFactory.get().create(nodesS.getObject());
                int o = offset.asLiteral().getInt();
                return new OffsetExpression((RDFNode)resource, nodes, o);
            }
            return null;
        });
        constructors.put(SH.orderBy, (resource, orderBy) -> {
            Statement nodesS = resource.getProperty(SH.nodes);
            if (nodesS != null) {
                NodeExpression nodes = NodeExpressionFactory.get().create(nodesS.getObject());
                NodeExpression comparator = NodeExpressionFactory.get().create((RDFNode)orderBy);
                boolean desc = resource.hasProperty(SH.desc, (RDFNode)JenaDatatypes.TRUE);
                return new OrderByExpression((RDFNode)resource, nodes, comparator, desc);
            }
            return null;
        });
        constructors.put(SH.path, (resource, path) -> {
            Statement nodesS = resource.getProperty(SH.nodes);
            NodeExpression nodes = nodesS != null ? NodeExpressionFactory.get().create(nodesS.getObject()) : null;
            return new PathExpression((RDFNode)resource, (Resource)path, nodes);
        });
        constructors.put(SH.select, (resource, select) -> {
            String queryString = select.asNode().getLiteralLexicalForm();
            Query arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(queryString, resource));
            Statement nodesS = resource.getProperty(SH.nodes);
            NodeExpression input = nodesS != null ? NodeExpressionFactory.get().create(nodesS.getObject()) : null;
            return new SelectExpression((Resource)resource, arqQuery, input, queryString);
        });
        constructors.put(SH.sum, (resource, sum) -> {
            NodeExpression nodes = NodeExpressionFactory.get().create((RDFNode)sum);
            return new SumExpression((RDFNode)resource, nodes);
        });
        constructors.put(SH.union, (resource, union) -> {
            LinkedList<NodeExpression> inputs = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)union.as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                inputs.add(NodeExpressionFactory.get().create(member));
            }
            return new UnionExpression((RDFNode)resource, inputs);
        });
        singleton = new NodeExpressionFactory();
    }
}

