/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractSpecialConstraintExecutorFactory;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ExpressionConstraintExecutor;
import org.topbraid.shacl.validation.PropertyConstraintExecutor;
import org.topbraid.shacl.validation.SpecialConstraintExecutorFactory;
import org.topbraid.shacl.validation.ValidationLanguage;
import org.topbraid.shacl.validation.js.JSConstraintExecutor;
import org.topbraid.shacl.validation.js.JSValidationLanguage;
import org.topbraid.shacl.validation.sparql.SPARQLConstraintExecutor;
import org.topbraid.shacl.validation.sparql.SPARQLValidationLanguage;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ConstraintExecutors {
    private static final ConstraintExecutors singleton = new ConstraintExecutors();
    private List<ValidationLanguage> languages = new ArrayList<ValidationLanguage>();
    private Map<Resource, SpecialConstraintExecutorFactory> specialExecutors = new HashMap<Resource, SpecialConstraintExecutorFactory>();

    public static ConstraintExecutors get() {
        return singleton;
    }

    public ConstraintExecutors() {
        this.addSpecialExecutor(SH.PropertyConstraintComponent, new AbstractSpecialConstraintExecutorFactory(){

            @Override
            public ConstraintExecutor create(Constraint constraint) {
                return new PropertyConstraintExecutor();
            }
        });
        this.addSpecialExecutor(DASH.ParameterConstraintComponent, new AbstractSpecialConstraintExecutorFactory(){

            @Override
            public ConstraintExecutor create(Constraint constraint) {
                return new PropertyConstraintExecutor();
            }
        });
        this.addSpecialExecutor(SH.JSConstraintComponent, new AbstractSpecialConstraintExecutorFactory(){

            @Override
            public ConstraintExecutor create(Constraint constraint) {
                return new JSConstraintExecutor();
            }
        });
        this.addSpecialExecutor(SH.SPARQLConstraintComponent, new AbstractSpecialConstraintExecutorFactory(){

            @Override
            public ConstraintExecutor create(Constraint constraint) {
                return new SPARQLConstraintExecutor(constraint);
            }
        });
        this.addSpecialExecutor(SH.ExpressionConstraintComponent, new AbstractSpecialConstraintExecutorFactory(){

            @Override
            public ConstraintExecutor create(Constraint constraint) {
                return new ExpressionConstraintExecutor();
            }
        });
        this.addLanguage(SPARQLValidationLanguage.get());
        this.addLanguage(JSValidationLanguage.get());
    }

    protected void addLanguage(ValidationLanguage language) {
        this.languages.add(language);
    }

    public void addSpecialExecutor(Resource constraintComponent, SpecialConstraintExecutorFactory executor) {
        this.specialExecutors.put(constraintComponent, executor);
    }

    public ConstraintExecutor getExecutor(Constraint constraint) {
        SpecialConstraintExecutorFactory special = this.specialExecutors.get(constraint.getComponent());
        if (special != null && special.canExecute(constraint)) {
            return special.create(constraint);
        }
        for (ValidationLanguage language : this.languages) {
            if (!language.canExecute(constraint)) continue;
            return language.createExecutor(constraint);
        }
        return null;
    }

    public void removeSpecialExecutor(Resource constraintComponent) {
        this.specialExecutors.remove(constraintComponent);
    }

    public void setJSPreferred(boolean value) {
        this.languages.remove(0);
        this.languages.remove(0);
        if (value) {
            this.languages.add(0, JSValidationLanguage.get());
            this.languages.add(1, SPARQLValidationLanguage.get());
        } else {
            this.languages.add(0, SPARQLValidationLanguage.get());
            this.languages.add(1, JSValidationLanguage.get());
        }
    }
}

