/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.util.RecursionGuard;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class PropertyConstraintExecutor
implements ConstraintExecutor {
    PropertyConstraintExecutor() {
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, List<RDFNode> focusNodes) {
        Node propertyShape = constraint.getParameterValue().asNode();
        if (constraint.getShapeResource().isPropertyShape()) {
            for (RDFNode focusNode : focusNodes) {
                List<RDFNode> valueNodes = engine.getValueNodes(constraint, focusNode);
                this.executeHelper(engine, valueNodes, propertyShape);
                engine.checkCanceled();
            }
        } else {
            this.executeHelper(engine, focusNodes, propertyShape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHelper(ValidationEngine engine, List<RDFNode> valueNodes, Node propertyShape) {
        LinkedList<RDFNode> doNodes = new LinkedList<RDFNode>();
        for (RDFNode focusNode : valueNodes) {
            if (RecursionGuard.start(focusNode.asNode(), propertyShape)) continue;
            doNodes.add(focusNode);
        }
        try {
            engine.validateNodesAgainstShape(doNodes, propertyShape);
        }
        finally {
            for (RDFNode valueNode : doNodes) {
                RecursionGuard.end(valueNode.asNode(), propertyShape);
            }
        }
    }
}

