/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ExpressionConstraintExecutor;
import org.topbraid.shacl.validation.PropertyConstraintExecutor;
import org.topbraid.shacl.validation.ValidationLanguage;
import org.topbraid.shacl.validation.js.JSConstraintExecutor;
import org.topbraid.shacl.validation.js.JSValidationLanguage;
import org.topbraid.shacl.validation.sparql.SPARQLConstraintExecutor;
import org.topbraid.shacl.validation.sparql.SPARQLValidationLanguage;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ConstraintExecutors {
    private static final ConstraintExecutors singleton = new ConstraintExecutors();
    private List<ValidationLanguage> languages = new ArrayList<ValidationLanguage>();
    private Map<Resource, Function<Constraint, ConstraintExecutor>> specialExecutors = new HashMap<Resource, Function<Constraint, ConstraintExecutor>>();

    public static ConstraintExecutors get() {
        return singleton;
    }

    public ConstraintExecutors() {
        this.addSpecialExecutor(SH.PropertyConstraintComponent, constraint -> new PropertyConstraintExecutor());
        this.addSpecialExecutor(DASH.ParameterConstraintComponent, constraint -> new PropertyConstraintExecutor());
        this.addSpecialExecutor(SH.JSConstraintComponent, constraint -> new JSConstraintExecutor());
        this.addSpecialExecutor(SH.SPARQLConstraintComponent, constraint -> new SPARQLConstraintExecutor((Constraint)constraint));
        this.addSpecialExecutor(SH.ExpressionConstraintComponent, constraint -> new ExpressionConstraintExecutor());
        this.addLanguage(SPARQLValidationLanguage.get());
        this.addLanguage(JSValidationLanguage.get());
    }

    protected void addLanguage(ValidationLanguage language) {
        this.languages.add(language);
    }

    public void addSpecialExecutor(Resource constraintComponent, Function<Constraint, ConstraintExecutor> executor) {
        this.specialExecutors.put(constraintComponent, executor);
    }

    public ConstraintExecutor getExecutor(Constraint constraint) {
        Function<Constraint, ConstraintExecutor> special = this.specialExecutors.get(constraint.getComponent());
        if (special != null) {
            return special.apply(constraint);
        }
        for (ValidationLanguage language : this.languages) {
            if (!language.canExecute(constraint)) continue;
            return language.createExecutor(constraint);
        }
        return null;
    }

    public void removeSpecialExecutor(Resource constraintComponent) {
        this.specialExecutors.remove(constraintComponent);
    }

    public void setJSPreferred(boolean value) {
        this.languages.remove(0);
        this.languages.remove(0);
        if (value) {
            this.languages.add(0, JSValidationLanguage.get());
            this.languages.add(1, SPARQLValidationLanguage.get());
        } else {
            this.languages.add(0, SPARQLValidationLanguage.get());
            this.languages.add(1, JSValidationLanguage.get());
        }
    }
}

