/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.AbstractEngine;
import org.topbraid.shacl.engine.ConfigurableEngine;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.filters.ExcludeMetaShapesFilter;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.targets.InstancesTarget;
import org.topbraid.shacl.targets.Target;
import org.topbraid.shacl.util.FailureLog;
import org.topbraid.shacl.util.SHACLPreferences;
import org.topbraid.shacl.validation.ClassesCache;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.MaximumNumberViolations;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ValidationEngine
extends AbstractEngine
implements ConfigurableEngine {
    private static ThreadLocal<ValidationEngine> current = new ThreadLocal();
    private ClassesCache classesCache;
    private ValidationEngineConfiguration configuration;
    private Predicate<RDFNode> focusNodeFilter;
    private Function<RDFNode, String> labelFunction = node -> RDFLabels.get().getNodeLabel((RDFNode)node);
    private Map<RDFNode, String> labelsCache = new ConcurrentHashMap<RDFNode, String>();
    private Resource report;
    private Map<ValueNodesCacheKey, Collection<RDFNode>> valueNodes = new WeakHashMap<ValueNodesCacheKey, Collection<RDFNode>>();
    private int violationsCount = 0;

    public static ValidationEngine getCurrent() {
        return current.get();
    }

    public static void setCurrent(ValidationEngine value) {
        current.set(value);
    }

    protected ValidationEngine(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, Resource report) {
        super(dataset, shapesGraph, shapesGraphURI);
        this.setConfiguration(new ValidationEngineConfiguration());
        if (report == null) {
            Model reportModel = JenaUtil.createMemoryModel();
            reportModel.setNsPrefixes((PrefixMapping)dataset.getDefaultModel());
            this.report = reportModel.createResource(SH.ValidationReport);
        } else {
            this.report = report;
        }
    }

    public Function<RDFNode, String> getLabelFunction() {
        return this.labelFunction;
    }

    public void setLabelFunction(Function<RDFNode, String> value) {
        this.labelFunction = value;
    }

    public void addResultMessage(Resource result, Literal message, QuerySolution bindings) {
        result.addProperty(SH.resultMessage, (RDFNode)SPARQLSubstitutions.withSubstitutions(message, bindings, this.getLabelFunction()));
    }

    public Resource createResult(Resource type, Constraint constraint, RDFNode focusNode) {
        Resource result = this.report.getModel().createResource(type);
        this.report.addProperty(SH.result, (RDFNode)result);
        result.addProperty(SH.resultSeverity, (RDFNode)constraint.getShape().getSeverity());
        result.addProperty(SH.sourceConstraintComponent, (RDFNode)constraint.getComponent());
        result.addProperty(SH.sourceShape, (RDFNode)constraint.getShapeResource());
        if (focusNode != null) {
            result.addProperty(SH.focusNode, focusNode);
        }
        this.checkMaximumNumberFailures(constraint);
        return result;
    }

    public Resource createValidationResult(Constraint constraint, RDFNode focusNode, RDFNode value, Supplier<String> defaultMessage) {
        Collection<RDFNode> messages;
        Resource result = this.createResult(SH.ValidationResult, constraint, focusNode);
        if (value != null) {
            result.addProperty(SH.value, value);
        }
        if (!constraint.getShape().isNodeShape()) {
            result.addProperty(SH.resultPath, (RDFNode)SHACLPaths.clonePath(constraint.getShapeResource().getPath(), result.getModel()));
        }
        if ((messages = constraint.getShape().getMessages()).size() > 0) {
            messages.stream().forEach(message -> result.addProperty(SH.resultMessage, message));
        } else if (defaultMessage != null) {
            result.addProperty(SH.resultMessage, defaultMessage.get());
        }
        return result;
    }

    private void checkMaximumNumberFailures(Constraint constraint) {
        if (constraint.getShape().getSeverity() == SH.Violation) {
            ++this.violationsCount;
            if (this.configuration.getValidationErrorBatch() != -1 && this.violationsCount == this.configuration.getValidationErrorBatch()) {
                throw new MaximumNumberViolations(this.violationsCount);
            }
        }
    }

    public ClassesCache getClassesCache() {
        return this.classesCache;
    }

    public String getLabel(RDFNode node) {
        return this.labelsCache.computeIfAbsent(node, n -> this.getLabelFunction().apply((RDFNode)n));
    }

    public Resource getReport() {
        return this.report;
    }

    private Set<Resource> getShapesForNode(RDFNode focusNode, Dataset dataset, Model shapesModel) {
        HashSet<Resource> shapes = new HashSet<Resource>();
        for (Shape rootShape : this.shapesGraph.getRootShapes()) {
            for (Target target : rootShape.getTargets()) {
                if (target instanceof InstancesTarget || !target.contains(dataset, focusNode)) continue;
                shapes.add(rootShape.getShapeResource());
            }
        }
        if (focusNode instanceof Resource) {
            for (Resource type : JenaUtil.getAllTypes((Resource)focusNode)) {
                if (JenaUtil.hasIndirectType(type.inModel(shapesModel), SH.Shape)) {
                    shapes.add(type);
                }
                for (Statement s : shapesModel.listStatements(null, SH.targetClass, (RDFNode)type).toList()) {
                    shapes.add(s.getSubject());
                }
            }
        }
        return shapes;
    }

    public Collection<RDFNode> getValueNodes(Constraint constraint, RDFNode focusNode) {
        if (constraint.getShape().isNodeShape()) {
            return Collections.singletonList(focusNode);
        }
        ValueNodesCacheKey key = new ValueNodesCacheKey(focusNode, constraint.getShape().getPath());
        return this.valueNodes.computeIfAbsent(key, k -> this.computeValueNodes(focusNode, constraint));
    }

    private Collection<RDFNode> computeValueNodes(RDFNode focusNode, Constraint constraint) {
        Property predicate = constraint.getShape().getPredicate();
        if (predicate != null) {
            LinkedList<RDFNode> results = new LinkedList<RDFNode>();
            if (focusNode instanceof Resource) {
                StmtIterator it = ((Resource)focusNode).listProperties(predicate);
                while (it.hasNext()) {
                    results.add(((Statement)it.next()).getObject());
                }
            }
            return results;
        }
        Path jenaPath = constraint.getShape().getJenaPath();
        if (jenaPath instanceof P_Inverse && ((P_Inverse)jenaPath).getSubPath() instanceof P_Link) {
            LinkedList<RDFNode> results = new LinkedList<RDFNode>();
            Property inversePredicate = ResourceFactory.createProperty((String)((P_Link)((P_Inverse)jenaPath).getSubPath()).getNode().getURI());
            StmtIterator it = focusNode.getModel().listStatements(null, inversePredicate, focusNode);
            while (it.hasNext()) {
                results.add((RDFNode)((Statement)it.next()).getSubject());
            }
            return results;
        }
        HashSet<RDFNode> results = new HashSet<RDFNode>();
        Iterator it = PathEval.eval((Graph)focusNode.getModel().getGraph(), (Node)focusNode.asNode(), (Path)jenaPath, (Context)Context.emptyContext);
        while (it.hasNext()) {
            Node node = (Node)it.next();
            results.add(focusNode.getModel().asRDFNode(node));
        }
        return results;
    }

    public void setClassesCache(ClassesCache value) {
        this.classesCache = value;
    }

    public void setFocusNodeFilter(Predicate<RDFNode> value) {
        this.focusNodeFilter = value;
    }

    public void updateConforms() {
        boolean conforms = true;
        StmtIterator it = this.report.listProperties(SH.result);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getResource().hasProperty(RDF.type, (RDFNode)SH.ValidationResult)) continue;
            conforms = false;
            it.close();
            break;
        }
        if (this.report.hasProperty(SH.conforms)) {
            this.report.removeAll(SH.conforms);
        }
        this.report.addProperty(SH.conforms, (RDFNode)(conforms ? JenaDatatypes.TRUE : JenaDatatypes.FALSE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateAll() throws InterruptedException {
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            List<Shape> rootShapes = this.shapesGraph.getRootShapes();
            if (this.monitor != null) {
                this.monitor.beginTask("Validating " + rootShapes.size() + " shapes", rootShapes.size());
            }
            if (this.classesCache == null) {
                this.classesCache = new ClassesCache();
            }
            int i = 0;
            for (Shape shape : rootShapes) {
                if (this.monitor != null) {
                    this.monitor.subTask("Shape " + ++i + ": " + this.getLabelFunction().apply((RDFNode)shape.getShapeResource()));
                }
                Collection<RDFNode> focusNodes = shape.getTargetNodes(this.dataset);
                if (this.focusNodeFilter != null) {
                    LinkedList<RDFNode> filteredFocusNodes = new LinkedList<RDFNode>();
                    for (RDFNode focusNode : focusNodes) {
                        if (!this.focusNodeFilter.test(focusNode)) continue;
                        filteredFocusNodes.add(focusNode);
                    }
                    focusNodes = filteredFocusNodes;
                }
                if (!focusNodes.isEmpty()) {
                    for (Constraint constraint : shape.getConstraints()) {
                        this.validateNodesAgainstConstraint(focusNodes, constraint);
                    }
                }
                if (this.monitor == null) continue;
                this.monitor.worked(1);
                if (!this.monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        catch (MaximumNumberViolations maximumNumberViolations) {
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        this.updateConforms();
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNode(Node focusNode) throws InterruptedException {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        RDFNode focusRDFNode = this.dataset.getDefaultModel().asRDFNode(focusNode);
        Set<Resource> shapes = this.getShapesForNode(focusRDFNode, this.dataset, shapesModel);
        boolean nested = SHACLScriptEngineManager.begin();
        try {
            for (Resource shape : shapes) {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.validateNodesAgainstShape(Collections.singletonList(focusRDFNode), shape.asNode());
            }
        }
        finally {
            SHACLScriptEngineManager.end(nested);
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNodesAgainstShape(List<RDFNode> focusNodes, Node shape) {
        Shape vs;
        if (!this.shapesGraph.isIgnored(shape) && !(vs = this.shapesGraph.getShape(shape)).isDeactivated()) {
            boolean nested = SHACLScriptEngineManager.begin();
            ValidationEngine oldEngine = current.get();
            current.set(this);
            try {
                for (Constraint constraint : vs.getConstraints()) {
                    this.validateNodesAgainstConstraint(focusNodes, constraint);
                }
            }
            finally {
                current.set(oldEngine);
                SHACLScriptEngineManager.end(nested);
            }
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodesConformToShape(List<RDFNode> focusNodes, Node shape) {
        block11: {
            if (!this.shapesGraph.isIgnored(shape)) {
                Resource oldReport = this.report;
                this.report = JenaUtil.createMemoryModel().createResource();
                try {
                    Shape vs = this.shapesGraph.getShape(shape);
                    if (vs.isDeactivated()) break block11;
                    boolean nested = SHACLScriptEngineManager.begin();
                    try {
                        Iterator<Constraint> iterator = vs.getConstraints().iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                Constraint constraint = iterator.next();
                                this.validateNodesAgainstConstraint(focusNodes, constraint);
                                if (!this.report.hasProperty(SH.result)) continue;
                                boolean bl = false;
                                return bl;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        SHACLScriptEngineManager.end(nested);
                    }
                }
                finally {
                    this.report = oldReport;
                }
            }
        }
        return true;
    }

    protected void validateNodesAgainstConstraint(Collection<RDFNode> focusNodes, Constraint constraint) {
        if (this.configuration != null && this.configuration.isSkippedConstraintComponent(constraint.getComponent())) {
            return;
        }
        ConstraintExecutor executor = constraint.getExecutor();
        if (executor != null) {
            if (SHACLPreferences.isProduceFailuresMode()) {
                try {
                    executor.executeConstraint(constraint, this, focusNodes);
                }
                catch (Exception ex) {
                    Resource result = this.createResult(DASH.FailureResult, constraint, null);
                    result.addProperty(SH.resultMessage, "Exception during validation: " + ExceptionUtil.getStackTrace(ex));
                }
            } else {
                executor.executeConstraint(constraint, this, focusNodes);
            }
        } else {
            FailureLog.get().logWarning("No suitable validator found for constraint " + constraint);
        }
    }

    @Override
    public ValidationEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(ValidationEngineConfiguration configuration) {
        this.configuration = configuration;
        if (!configuration.getValidateShapes()) {
            this.shapesGraph.setShapeFilter(new ExcludeMetaShapesFilter());
        }
    }

    private static class ValueNodesCacheKey {
        Resource path;
        RDFNode focusNode;

        ValueNodesCacheKey(RDFNode focusNode, Resource path) {
            this.path = path;
            this.focusNode = focusNode;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueNodesCacheKey) {
                return this.path.equals((Object)((ValueNodesCacheKey)o).path) && this.focusNode.equals(((ValueNodesCacheKey)o).focusNode);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() + this.focusNode.hashCode();
        }

        public String toString() {
            return this.focusNode.toString() + " . " + this.path;
        }
    }
}

