/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 */
package org.topbraid.jenax.util;

import java.io.* ;
import java.nio.charset.StandardCharsets ;

public class IOUtil {

	public static StringBuffer loadString(Reader reader) throws IOException {
	    try(BufferedReader bis = new BufferedReader(reader)) {
		    StringBuffer sb = new StringBuffer();
		    for (;;) {
		        int c = bis.read();
		        if (c < 0) {
		            break;
		        }
		        sb.append((char)c);
		    }
		    return sb;
		}
	}

	public static StringBuffer loadStringUTF8(InputStream in) throws IOException {
	    return loadString(new InputStreamReader(in, StandardCharsets.UTF_8));
	}
}
