/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.JSScriptEngineFactory;
import org.topbraid.shacl.js.NashornScriptEngine;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.testcases.TestCaseTypes;
import org.topbraid.shacl.util.SHACLSystemModel;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

@RunWith(value=Parameterized.class)
public class TestDASHTestCases {
    private TestCase testCase;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() throws Exception {
        LinkedList<TestCase> testCases = new LinkedList<TestCase>();
        File rootFolder = new File("src/test/resources");
        TestDASHTestCases.collectTestCases(rootFolder, testCases);
        LinkedList<Object[]> results = new LinkedList<Object[]>();
        for (TestCase testCase : testCases) {
            results.add(new Object[]{testCase});
        }
        return results;
    }

    private static void collectTestCases(File folder, List<TestCase> testCases) throws Exception {
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                TestDASHTestCases.collectTestCases(f, testCases);
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".ttl")) continue;
            Model testModel = JenaUtil.createDefaultModel();
            FileInputStream is = new FileInputStream(f);
            testModel.read((InputStream)is, "urn:dummy", "TURTLE");
            testModel.add(SHACLSystemModel.getSHACLModel());
            Resource ontology = ((Statement)testModel.listStatements(null, OWL.imports, (RDFNode)ResourceFactory.createResource((String)"http://datashapes.org/dash")).next()).getSubject();
            for (TestCaseType type : TestCaseTypes.getTypes()) {
                testCases.addAll(type.getTestCases(testModel, ontology));
            }
        }
    }

    public TestDASHTestCases(TestCase testCase) {
        this.testCase = testCase;
    }

    @Test
    public void testTestCase() {
        System.out.println(" - " + this.testCase.getResource());
        Model results = JenaUtil.createMemoryModel();
        try {
            this.testCase.run(results);
        }
        catch (Exception ex) {
            this.testCase.createFailure(results, "Exception during test case execution: " + ex);
            ex.printStackTrace();
        }
        for (Statement s : results.listStatements(null, RDF.type, (RDFNode)DASH.FailureTestCaseResult).toList()) {
            String message = JenaUtil.getStringProperty((Resource)s.getSubject(), (Property)SH.resultMessage);
            if (message == null) {
                message = "(No sh:" + SH.resultMessage.getLocalName() + " found in failure)";
            }
            Assert.fail((String)(this.testCase.getResource() + ": " + message));
        }
    }

    static {
        JSScriptEngineFactory.set((JSScriptEngineFactory)new JSScriptEngineFactory(){

            public JSScriptEngine createScriptEngine() {
                return new NashornScriptEngine(){

                    protected Reader createScriptReader(String url) throws Exception {
                        if ("http://datashapes.org/js/dash.js".equals(url)) {
                            return new InputStreamReader(NashornScriptEngine.class.getResourceAsStream("/js/dash.js"));
                        }
                        if ("http://datashapes.org/js/rdfquery.js".equals(url)) {
                            return new InputStreamReader(NashornScriptEngine.class.getResourceAsStream("/js/rdfquery.js"));
                        }
                        if (url.startsWith("http://datashapes.org/js/")) {
                            return new InputStreamReader(NashornScriptEngine.class.getResourceAsStream(url.substring(21)));
                        }
                        return new InputStreamReader(new URL(url).openStream());
                    }
                };
            }
        });
    }
}

