/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.net.URI;
import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterExtendByVar;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.PathEvaluator;

public class ValuesPFunction
extends PropertyFunctionBase {
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        if (!argSubject.isList() || argSubject.getArgListSize() != 2) {
            throw new ExprEvalException("Left hand side of tosh:values must be a list with two members");
        }
        Node focusNode = (Node)argSubject.getArgList().get(0);
        Node predicateNode = (Node)argSubject.getArgList().get(1);
        if (predicateNode.isVariable()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        Model model = ModelFactory.createModelForGraph((Graph)execCxt.getActiveGraph());
        final Dataset dataset = ARQFactory.get().getDataset(model);
        final URI shapesGraphURI = URI.create("urn:x-topbraid:dummyShapesGraph");
        dataset.addNamedModel(shapesGraphURI.toString(), model);
        final ShapesGraph shapesGraph = new ShapesGraph(model);
        PathEvaluator eval = new PathEvaluator(model.getProperty(predicateNode.getURI()));
        NodeExpressionContext context = new NodeExpressionContext(){

            @Override
            public URI getShapesGraphURI() {
                return shapesGraphURI;
            }

            @Override
            public ShapesGraph getShapesGraph() {
                return shapesGraph;
            }

            @Override
            public Dataset getDataset() {
                return dataset;
            }
        };
        if (argObject.getArg().isVariable()) {
            if (focusNode.isVariable()) {
                return IterLib.noResults((ExecutionContext)execCxt);
            }
            ExtendedIterator<RDFNode> it = eval.eval(model.asRDFNode(focusNode), context);
            ExtendedIterator nit = it.mapWith(rdfNode -> rdfNode.asNode());
            return new QueryIterExtendByVar(binding, (Var)argObject.getArg(), (Iterator)nit, execCxt);
        }
        if (focusNode.isVariable()) {
            if (eval.isReversible(shapesGraph)) {
                ExtendedIterator<RDFNode> it = eval.evalReverse(model.asRDFNode(argObject.getArg()), context);
                ExtendedIterator nit = it.mapWith(rdfNode -> rdfNode.asNode());
                return new QueryIterExtendByVar(binding, (Var)focusNode, (Iterator)nit, execCxt);
            }
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        ExtendedIterator<RDFNode> it = eval.eval(model.asRDFNode(focusNode), context);
        while (it.hasNext()) {
            RDFNode n = (RDFNode)it.next();
            if (!n.asNode().equals((Object)argObject.getArg())) continue;
            it.close();
            return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
        }
        return IterLib.noResults((ExecutionContext)execCxt);
    }
}

