/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.compact;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.util.ModelPrinter;

class SHACLCTestRunner {
    SHACLCTestRunner() {
    }

    public void run() {
        File folder = new File("C:\\Users\\Holger\\Documents\\GitHub\\data-shapes\\shacl-compact-syntax\\tests");
        this.runFolder(folder);
    }

    private void runFolder(File folder) {
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.runFolder(f);
                continue;
            }
            if (!f.getName().endsWith(".shaclc")) continue;
            this.runFile(f);
        }
    }

    private void runFile(File compactFile) {
        try {
            Model compactModel = JenaUtil.createMemoryModel();
            compactModel.read((Reader)new FileReader(compactFile), "urn:x-base:default", "SHACLC");
            compactModel.removeAll(null, OWL.imports, (RDFNode)ResourceFactory.createResource((String)"http://datashapes.org/dash"));
            File turtleFile = new File(compactFile.getParentFile(), compactFile.getName().replaceAll(".shaclc", ".ttl"));
            Model turtleModel = JenaUtil.createMemoryModel();
            turtleModel.read((Reader)new FileReader(turtleFile), "urn:x-base:default", "TURTLE");
            if (compactModel.getGraph().isIsomorphicWith(turtleModel.getGraph())) {
                System.out.println("Passed test " + compactFile);
            } else {
                System.err.println("Failed test " + compactFile);
                System.err.println("Turtle:  " + ModelPrinter.get().print(turtleModel));
                System.err.println("Compact: " + ModelPrinter.get().print(compactModel));
            }
        }
        catch (Exception ex) {
            System.err.println("Exception during test " + compactFile + ": " + ex);
            ex.printStackTrace();
        }
    }
}

