/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class IntersectionExpression
extends ComplexNodeExpression {
    private List<NodeExpression> inputs;

    public IntersectionExpression(RDFNode expr, List<NodeExpression> inputs) {
        super(expr);
        this.inputs = inputs;
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        Iterator<NodeExpression> it = this.inputs.iterator();
        if (it.hasNext()) {
            NodeExpression first = it.next();
            HashSet results = new HashSet(first.eval(focusNode, context).toList());
            while (it.hasNext()) {
                NodeExpression next = it.next();
                results.retainAll(next.eval(focusNode, context).toList());
            }
            return WrappedIterator.create(results.iterator());
        }
        return WrappedIterator.emptyIterator();
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        LinkedList<String> results = new LinkedList<String>();
        for (NodeExpression expr : this.inputs) {
            results.add(expr.getFunctionalSyntax());
        }
        return results;
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        return this.inputs;
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        if (this.inputs.size() == 0) {
            return null;
        }
        Resource s = this.inputs.get(0).getOutputShape(contextShape);
        if (s == null) {
            return null;
        }
        for (int i = 1; i < this.inputs.size(); ++i) {
            Resource o = this.inputs.get(i).getOutputShape(contextShape);
            if (s.equals((Object)o)) continue;
            return null;
        }
        return s;
    }

    @Override
    public String getTypeId() {
        return "intersection";
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

