/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.Set;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class LanguageInConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private Set<String> langs;

    LanguageInConstraintExecutor(Constraint constraint) {
        RDFList list = (RDFList)constraint.getParameterValue().as(RDFList.class);
        this.langs = list.iterator().mapWith(n -> n.asLiteral().getString()).toSet();
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        for (RDFNode focusNode : focusNodes) {
            for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                if (!valueNode.isLiteral()) {
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Not a literal");
                    continue;
                }
                String lang = valueNode.asLiteral().getLanguage();
                if (lang.isEmpty()) {
                    if (this.langs.contains(lang)) continue;
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value without language tag");
                    continue;
                }
                if (this.langMatches(lang)) continue;
                engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value does not have a matching language tag");
            }
            engine.checkCanceled();
        }
        this.addStatistics(constraint, startTime);
    }

    private boolean langMatches(String l) {
        for (String lang : this.langs) {
            if (!NodeFunctions.langMatches((String)l, (String)lang)) continue;
            return true;
        }
        return false;
    }
}

