/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class DisjointConstraintExecutor
extends AbstractNativeConstraintExecutor {
    DisjointConstraintExecutor() {
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        Property disjointPredicate = (Property)constraint.getParameterValue().as(Property.class);
        for (RDFNode focusNode : focusNodes) {
            if (focusNode instanceof Resource) {
                for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                    if (!((Resource)focusNode).hasProperty(disjointPredicate, valueNode)) continue;
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Property must not share any values with " + engine.getLabelFunction().apply((RDFNode)disjointPredicate));
                }
            }
            engine.checkCanceled();
        }
        this.addStatistics(constraint, startTime);
    }
}

