/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.HashSet;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class UniqueLangConstraintExecutor
extends AbstractNativeConstraintExecutor {
    UniqueLangConstraintExecutor() {
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        if (JenaDatatypes.TRUE.equals((Object)constraint.getParameterValue())) {
            for (RDFNode focusNode : focusNodes) {
                HashSet<String> langs = new HashSet<String>();
                HashSet<String> reported = new HashSet<String>();
                Collection<RDFNode> valueNodes = engine.getValueNodes(constraint, focusNode);
                for (RDFNode valueNode : valueNodes) {
                    if (!valueNode.isLiteral() || valueNode.asNode().getLiteralLanguage().length() <= 0) continue;
                    String lang = valueNode.asNode().getLiteralLanguage();
                    if (langs.contains(lang)) {
                        if (reported.contains(lang)) continue;
                        reported.add(lang);
                        engine.createValidationResult(constraint, focusNode, null, () -> "Language \"" + lang + "\" used more than once");
                        continue;
                    }
                    langs.add(lang);
                }
                engine.checkCanceled();
            }
        }
        this.addStatistics(constraint, startTime);
    }
}

