/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.jena.sparql.graph.PrefixMappingBase;

public class PrefixMappingMem
extends PrefixMappingBase {
    private Map<String, String> prefixToUri = new ConcurrentHashMap<String, String>();
    private Map<String, String> uriToPrefix = new ConcurrentHashMap<String, String>();

    @Override
    protected void add(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    @Override
    protected void remove(String prefix) {
        String u = this.prefixToUri(prefix);
        if (u == null) {
            return;
        }
        String p = this.findReverseMapping(u, prefix);
        this.prefixToUri.remove(prefix);
        this.uriToPrefix.remove(u);
        if (p != null) {
            this.uriToPrefix.put(u, p);
        }
    }

    protected String findReverseMapping(String uri, String prefixExclude) {
        Objects.requireNonNull(prefixExclude);
        for (Map.Entry<String, String> e2 : this.prefixToUri.entrySet()) {
            String p = e2.getKey();
            String u = e2.getValue();
            if (!uri.equals(u) || prefixExclude.equals(p)) continue;
            return p;
        }
        return null;
    }

    @Override
    protected void clear() {
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
    }

    @Override
    protected boolean isEmpty() {
        return this.prefixToUri.isEmpty();
    }

    @Override
    protected int size() {
        return this.prefixToUri.size();
    }

    @Override
    protected String prefixToUri(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    @Override
    protected String uriToPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    @Override
    protected Map<String, String> asMap() {
        return this.prefixToUri;
    }

    @Override
    protected Map<String, String> asMapCopy() {
        return new HashMap<String, String>(this.prefixToUri);
    }

    @Override
    protected void apply(BiConsumer<String, String> action) {
        this.prefixToUri.forEach(action);
    }
}

