/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.web.DatasetGraphAccessor;

public class DatasetGraphAccessorHTTP
implements DatasetGraphAccessor {
    private static final HttpResponseHandler noResponse = HttpResponseLib.nullResponse;
    private static final RDFFormat defaultSendLang = RDFFormat.RDFXML_PLAIN;
    private final String remote;
    private HttpClient client;
    private RDFFormat formatPutPost = defaultSendLang;
    private String graphAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5";

    public RDFFormat getOutboundSyntax() {
        return this.formatPutPost;
    }

    public void setOutboundSyntax(RDFFormat format) {
        this.formatPutPost = format;
    }

    public String getGraphAcceptHeader() {
        return this.graphAcceptHeader;
    }

    public void setGraphAcceptHeader(String header) {
        this.graphAcceptHeader = header;
    }

    public DatasetGraphAccessorHTTP(String remote) {
        this(remote, HttpOp.getDefaultHttpClient());
    }

    public DatasetGraphAccessorHTTP(String remote, HttpClient client) {
        this.remote = remote;
        this.setClient(client);
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public Graph httpGet() {
        return this.doGet(this.targetDefault());
    }

    @Override
    public Graph httpGet(Node graphName) {
        return this.doGet(this.target(graphName));
    }

    protected Graph doGet(String url) {
        HttpCaptureResponse<Graph> graph = HttpResponseLib.graphHandler();
        try {
            HttpOp.execHttpGet(url, this.graphAcceptHeader, graph, this.client, null);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
        return graph.get();
    }

    @Override
    public boolean httpHead() {
        return this.doHead(this.targetDefault());
    }

    @Override
    public boolean httpHead(Node graphName) {
        return this.doHead(this.target(graphName));
    }

    protected boolean doHead(String url) {
        try {
            HttpOp.execHttpHead(url, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5", noResponse, this.client, null);
            return true;
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public void httpPut(Graph data) {
        this.doPut(this.targetDefault(), data);
    }

    @Override
    public void httpPut(Node graphName, Graph data) {
        this.doPut(this.target(graphName), data);
    }

    protected void doPut(String url, Graph data) {
        HttpEntity entity = this.graphToHttpEntity(data);
        HttpOp.execHttpPut(url, entity, this.client, null);
    }

    @Override
    public void httpDelete() {
        this.doDelete(this.targetDefault());
    }

    @Override
    public void httpDelete(Node graphName) {
        this.doDelete(this.target(graphName));
    }

    protected void doDelete(String url) {
        block2: {
            try {
                HttpOp.execHttpDelete(url, noResponse, this.client, null);
            }
            catch (HttpException ex) {
                if (ex.getStatusCode() != 404) break block2;
                return;
            }
        }
    }

    @Override
    public void httpPost(Graph data) {
        this.doPost(this.targetDefault(), data);
    }

    @Override
    public void httpPost(Node graphName, Graph data) {
        this.doPost(this.target(graphName), data);
    }

    protected void doPost(String url, Graph data) {
        HttpEntity entity = this.graphToHttpEntity(data);
        HttpOp.execHttpPost(url, entity, this.client, null);
    }

    @Override
    public void httpPatch(Graph data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void httpPatch(Node graphName, Graph data) {
        throw new UnsupportedOperationException();
    }

    protected final String targetDefault() {
        return this.remote + "?" + "default";
    }

    protected final String target(Node name) {
        if (!name.isURI()) {
            throw new JenaException("Not a URI: " + name);
        }
        String guri = name.getURI();
        guri = IRILib.encodeUriComponent((String)guri);
        return this.remote + "?" + "graph" + "=" + guri;
    }

    protected HttpEntity graphToHttpEntity(final Graph graph) {
        final RDFFormat syntax = this.getOutboundSyntax();
        ContentProducer producer = new ContentProducer(){

            public void writeTo(OutputStream out) {
                RDFDataMgr.write(out, graph, syntax);
            }
        };
        EntityTemplate entity = new EntityTemplate(producer);
        String ct = syntax.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }
}

