/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;
import org.topbraid.shacl.expr.PathEvaluator;
import org.topbraid.shacl.vocabulary.SH;

public class PathExpression
extends AbstractInputExpression {
    private PathEvaluator eval;
    private Resource path;
    private String pathString;

    public PathExpression(RDFNode expr, Resource path, NodeExpression input) {
        super(expr, input);
        this.path = path;
        if (path.isAnon()) {
            this.pathString = SHACLPaths.getPathString(path);
            Path jenaPath = (Path)SHACLPaths.getJenaPath(this.pathString, path.getModel());
            this.eval = new PathEvaluator(jenaPath, expr.getModel());
        } else {
            this.pathString = FmtUtils.stringForRDFNode((RDFNode)path);
            this.eval = new PathEvaluator(JenaUtil.asProperty(path));
        }
        this.eval.setInput(input);
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        try {
            return this.eval.eval(focusNode, context);
        }
        catch (StackOverflowError ex) {
            throw new IllegalArgumentException("Stack overflow: likely due to recursive dependencies between inferences around SHACL path expression " + this, ex);
        }
    }

    @Override
    public ExtendedIterator<RDFNode> evalReverse(RDFNode valueNode, NodeExpressionContext context) {
        return this.eval.evalReverse(valueNode, context);
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        LinkedList<String> results = new LinkedList<String>();
        results.add(this.pathString);
        NodeExpression input = this.getInput();
        if (input != null) {
            results.add(input.getFunctionalSyntax());
        }
        return results;
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        if (this.path.isURIResource()) {
            if (this.getInput() != null) {
                contextShape = this.getInput().getOutputShape(contextShape);
            }
            if (contextShape != null) {
                return JenaUtil.getNearest(contextShape, c -> {
                    for (Resource ps : JenaUtil.getResourceProperties(c, SH.property)) {
                        if (!ps.hasProperty(SH.path, (RDFNode)this.path)) continue;
                        Resource node = JenaUtil.getResourceProperty(ps, SH.node);
                        if (node != null && node.isURIResource()) {
                            return node;
                        }
                        Resource cls = JenaUtil.getResourceProperty(ps, SH.class_);
                        if (cls == null || !cls.isURIResource()) continue;
                        return cls;
                    }
                    return null;
                });
            }
        }
        return null;
    }

    public Resource getPath() {
        return this.path;
    }

    @Override
    public String getTypeId() {
        return "path";
    }

    public boolean isMaybeInferred(ShapesGraph shapesGraph) {
        return this.eval.isMaybeInferred(shapesGraph);
    }

    @Override
    public boolean isReversible(NodeExpressionContext context) {
        return this.eval.isReversible(context.getShapesGraph());
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

