/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.templates;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class Templates {
    public static Model construct(Resource template, QuerySolutionMap bindings, Dataset dataset) {
        Model result = JenaUtil.createDefaultModel();
        template.listProperties(SH.construct).filterKeep(s -> s.getObject().isLiteral()).forEachRemaining(s -> {
            String queryString = s.getString();
            Query arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(queryString, template));
            try (QueryExecution qexec = ARQFactory.get().createQueryExecution(arqQuery, dataset, (QuerySolution)bindings);){
                qexec.execConstruct(result);
            }
        });
        return result;
    }

    public static QueryExecution select(Resource template, QuerySolutionMap bindings, Dataset dataset) {
        String queryString = JenaUtil.getStringProperty(template, SH.select);
        Query arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(queryString, template));
        return ARQFactory.get().createQueryExecution(arqQuery, dataset, (QuerySolution)bindings);
    }
}

