/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.util.ModelPrinter;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.validation.ValidationSuggestionGenerator;
import org.topbraid.shacl.validation.ValidationSuggestionGeneratorFactory;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class GraphValidationTestCaseType
extends TestCaseType {
    public static final List<Property> IGNORED_PROPERTIES = Arrays.asList(SH.message, SH.resultMessage, DASH.suggestionGroup);

    public static void addStatements(Model model, Statement s) {
        if (!IGNORED_PROPERTIES.contains(s.getPredicate())) {
            model.add(s);
        }
        if (s.getObject().isAnon()) {
            for (Statement t : s.getModel().listStatements(s.getResource(), null, (RDFNode)null).toList()) {
                GraphValidationTestCaseType.addStatements(model, t);
            }
        }
    }

    public static void addSuggestions(Model dataModel, Model shapesModel, Model actualResults) {
        ValidationSuggestionGenerator generator = ValidationSuggestionGeneratorFactory.get().createValidationSuggestionGenerator(dataModel, shapesModel);
        if (generator == null) {
            throw new UnsupportedOperationException("Cannot run test due to no suggestion generator installed");
        }
        generator.addSuggestions(actualResults, Integer.MAX_VALUE, null);
    }

    public GraphValidationTestCaseType() {
        super(DASH.GraphValidationTestCase);
    }

    @Override
    protected TestCase createTestCase(Resource graph, Resource resource) {
        return new GraphValidationTestCase(graph, resource);
    }

    private static class GraphValidationTestCase
    extends TestCase {
        GraphValidationTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        @Override
        public void run(Model results) throws Exception {
            Model dataModel = SHACLUtil.withDefaultValueTypeInferences(this.getResource().getModel());
            Dataset dataset = ARQFactory.get().getDataset(dataModel);
            URI shapesGraphURI = SHACLUtil.withShapesGraph(dataset);
            ShapesGraph shapesGraph = new ShapesGraph(dataset.getNamedModel(shapesGraphURI.toString()));
            ValidationEngineConfiguration configuration = new ValidationEngineConfiguration();
            if (!this.getResource().hasProperty(DASH.validateShapes, (RDFNode)JenaDatatypes.TRUE)) {
                configuration.setValidateShapes(false);
            }
            ValidationEngine validationEngine = ValidationEngineFactory.get().create(dataset, shapesGraphURI, shapesGraph, null);
            validationEngine.setConfiguration(configuration);
            validationEngine.applyEntailments();
            Resource actualReport = validationEngine.validateAll();
            Model actualResults = actualReport.getModel();
            if (this.getResource().hasProperty(DASH.includeSuggestions, (RDFNode)JenaDatatypes.TRUE)) {
                Model shapesModel = dataset.getNamedModel(shapesGraphURI.toString());
                GraphValidationTestCaseType.addSuggestions(dataModel, shapesModel, actualResults);
            }
            actualResults.setNsPrefix("sh", "http://www.w3.org/ns/shacl#");
            actualResults.setNsPrefix("rdf", RDF.getURI());
            actualResults.setNsPrefix("rdfs", RDFS.getURI());
            for (Property ignoredProperty : IGNORED_PROPERTIES) {
                actualResults.removeAll(null, ignoredProperty, (RDFNode)null);
            }
            Model expectedModel = JenaUtil.createDefaultModel();
            Resource expectedReport = this.getResource().getPropertyResourceValue(DASH.expectedResult);
            for (Statement s : expectedReport.listProperties().toList()) {
                expectedModel.add(s);
            }
            for (Statement s : expectedReport.listProperties(SH.result).toList()) {
                for (Statement t : s.getResource().listProperties().toList()) {
                    if (t.getPredicate().equals(DASH.suggestion)) {
                        GraphValidationTestCaseType.addStatements(expectedModel, t);
                        continue;
                    }
                    if (SH.resultPath.equals(t.getPredicate())) {
                        expectedModel.add(t.getSubject(), t.getPredicate(), (RDFNode)SHACLPaths.clonePath(t.getResource(), expectedModel));
                        continue;
                    }
                    expectedModel.add(t);
                    if (!SH.detail.equals(t.getPredicate())) continue;
                    for (Statement n : t.getResource().listProperties().toList()) {
                        expectedModel.add(n);
                    }
                }
            }
            if (expectedModel.getGraph().isIsomorphicWith(actualResults.getGraph())) {
                this.createResult(results, DASH.SuccessTestCaseResult);
            } else {
                System.out.println("Expected: " + ModelPrinter.get().print(expectedModel) + "\nActual: " + ModelPrinter.get().print(actualResults));
                this.createFailure(results, "Mismatching validation results. Expected " + expectedModel.size() + " triples, found " + actualResults.size());
            }
        }
    }
}

