/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class MinCountConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private int minCount;

    MinCountConstraintExecutor(Constraint constraint) {
        this.minCount = constraint.getParameterValue().asLiteral().getInt();
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        for (RDFNode focusNode : focusNodes) {
            int count = engine.getValueNodes(constraint, focusNode).size();
            if (count < this.minCount) {
                engine.createValidationResult(constraint, focusNode, null, () -> "Property needs to have at least " + this.minCount + " values, but found " + count);
            }
            engine.checkCanceled();
        }
        this.addStatistics(constraint, startTime);
    }
}

