/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.js;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.sse.builders.ExprBuildException;

public class JSEngine {
    private ScriptEngine scriptEngine;
    private CompiledScript compiledScript;
    private final Invocable invoc;
    private String functions;
    private String functionLibFile;

    public static JSEngine createFromString(String functions) {
        return new JSEngine(functions, null);
    }

    public static JSEngine createFromFile(String functionLibFile) {
        return new JSEngine(null, functionLibFile);
    }

    JSEngine(String functions, String functionLibFile) {
        this.functions = functions;
        this.functionLibFile = functionLibFile;
        this.invoc = JSEngine.build(functions, functionLibFile);
    }

    private static Invocable build(String functions, String functionLibFile) {
        if (functions == null && functionLibFile == null) {
            throw new ARQException("Both script string and script filename are null");
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine scriptEngine = manager.getEngineByName("nashorn");
        Invocable invoc = (Invocable)((Object)scriptEngine);
        if (functionLibFile != null) {
            try {
                BufferedReader reader = Files.newBufferedReader(Paths.get(functionLibFile, new String[0]), StandardCharsets.UTF_8);
                Object object = scriptEngine.eval(reader);
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                throw new RiotNotFoundException("File: " + functionLibFile);
            }
            catch (IOException ex) {
                IO.exception((IOException)ex);
            }
            catch (ScriptException e2) {
                throw new ExprBuildException("Failed to load Javascript", e2);
            }
        }
        if (functions != null) {
            try {
                Object e2 = scriptEngine.eval(functions);
            }
            catch (ScriptException e3) {
                throw new ExprBuildException("Failed to load Javascript", e3);
            }
        }
        try {
            invoc.invokeFunction("arqJSinit", new Object[0]);
        }
        catch (NoSuchMethodException e3) {
        }
        catch (ScriptException ex) {
            throw new ARQException("Failed to call JavaScript initialization function", ex);
        }
        return invoc;
    }

    public Object call(String functionName, Object[] args) throws NoSuchMethodException, ScriptException {
        return this.invoc.invokeFunction(functionName, args);
    }
}

