/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path1;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.shacl.vocabulary.SH;

public class SHACLPaths {
    private static final String ALTERNATIVE_PATH_SEPARATOR = "|";
    private static final String SEQUENCE_PATH_SEPARATOR = "/";

    public static void addValueNodes(RDFNode focusNode, Path path, Collection<RDFNode> results) {
        HashSet<Node> seen = new HashSet<Node>();
        Iterator it = PathEval.eval((Graph)focusNode.getModel().getGraph(), (Node)focusNode.asNode(), (Path)path, (Context)Context.emptyContext);
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (seen.contains(node)) continue;
            seen.add(node);
            results.add(focusNode.getModel().asRDFNode(node));
        }
    }

    public static void addValueNodes(RDFNode focusNode, Property predicate, Collection<RDFNode> results) {
        if (focusNode instanceof Resource) {
            StmtIterator it = ((Resource)focusNode).listProperties(predicate);
            while (it.hasNext()) {
                results.add(((Statement)it.next()).getObject());
            }
        }
    }

    public static void appendPath(StringBuffer sb, Resource path) {
        if (path.isURIResource()) {
            sb.append(FmtUtils.stringForNode((Node)path.asNode(), (PrefixMapping)path.getModel()));
        } else {
            SHACLPaths.appendPathBlankNode(sb, path, SEQUENCE_PATH_SEPARATOR);
        }
    }

    private static void appendNestedPath(StringBuffer sb, Resource path, String separator) {
        if (path.isURIResource()) {
            sb.append(FmtUtils.stringForNode((Node)path.asNode(), (PrefixMapping)path.getModel()));
        } else {
            sb.append("(");
            SHACLPaths.appendPathBlankNode(sb, path, separator);
            sb.append(")");
        }
    }

    private static void appendPathBlankNode(StringBuffer sb, Resource path, String separator) {
        if (path.hasProperty(RDF.first)) {
            ExtendedIterator it = ((RDFList)path.as(RDFList.class)).iterator();
            while (it.hasNext()) {
                Resource item = (Resource)it.next();
                SHACLPaths.appendNestedPath(sb, item, SEQUENCE_PATH_SEPARATOR);
                if (!it.hasNext()) continue;
                sb.append(" ");
                sb.append(separator);
                sb.append(" ");
            }
        } else if (path.hasProperty(SH.inversePath)) {
            sb.append("^");
            if (path.getProperty(SH.inversePath).getObject().isAnon()) {
                sb.append("(");
                SHACLPaths.appendPath(sb, path.getPropertyResourceValue(SH.inversePath));
                sb.append(")");
            } else {
                SHACLPaths.appendPath(sb, path.getPropertyResourceValue(SH.inversePath));
            }
        } else if (path.hasProperty(SH.alternativePath)) {
            SHACLPaths.appendNestedPath(sb, path.getPropertyResourceValue(SH.alternativePath), ALTERNATIVE_PATH_SEPARATOR);
        } else if (path.hasProperty(SH.zeroOrMorePath)) {
            SHACLPaths.appendNestedPath(sb, path.getPropertyResourceValue(SH.zeroOrMorePath), SEQUENCE_PATH_SEPARATOR);
            sb.append("*");
        } else if (path.hasProperty(SH.oneOrMorePath)) {
            SHACLPaths.appendNestedPath(sb, path.getPropertyResourceValue(SH.oneOrMorePath), SEQUENCE_PATH_SEPARATOR);
            sb.append("+");
        } else if (path.hasProperty(SH.zeroOrOnePath)) {
            SHACLPaths.appendNestedPath(sb, path.getPropertyResourceValue(SH.zeroOrOnePath), SEQUENCE_PATH_SEPARATOR);
            sb.append("?");
        }
    }

    public static Resource clonePath(Resource path, Model targetModel) {
        if (path.isURIResource()) {
            return path.inModel(targetModel);
        }
        Resource clone = targetModel.createResource();
        for (Statement s : path.listProperties().toList()) {
            Resource newObject;
            if (s.getSubject().hasProperty(RDF.first)) {
                if (!RDF.first.equals(s.getPredicate()) && !RDF.rest.equals(s.getPredicate())) continue;
                newObject = SHACLPaths.clonePath(s.getResource(), targetModel);
                clone.addProperty(s.getPredicate(), (RDFNode)newObject);
                continue;
            }
            newObject = SHACLPaths.clonePath(s.getResource(), targetModel);
            clone.addProperty(s.getPredicate(), (RDFNode)newObject);
        }
        return clone;
    }

    public static Resource createPath(Path path, Model model) {
        if (path instanceof P_Alt) {
            Resource result = model.createResource();
            RDFList list = model.createList(Arrays.asList(SHACLPaths.createPath(((P_Alt)path).getLeft(), model), SHACLPaths.createPath(((P_Alt)path).getRight(), model)).iterator());
            result.addProperty(SH.alternativePath, (RDFNode)list);
            return result;
        }
        if (path instanceof P_Inverse) {
            Resource result = model.createResource();
            result.addProperty(SH.inversePath, (RDFNode)SHACLPaths.createPath(((P_Inverse)path).getSubPath(), model));
            return result;
        }
        if (path instanceof P_Link) {
            return (Resource)model.asRDFNode(((P_Link)path).getNode());
        }
        if (path instanceof P_OneOrMore1 || path instanceof P_OneOrMoreN) {
            Resource result = model.createResource();
            result.addProperty(SH.oneOrMorePath, (RDFNode)SHACLPaths.createPath(((P_Path1)path).getSubPath(), model));
            return result;
        }
        if (path instanceof P_Seq) {
            return model.createList(Arrays.asList(SHACLPaths.createPath(((P_Seq)path).getLeft(), model), SHACLPaths.createPath(((P_Seq)path).getRight(), model)).iterator());
        }
        if (path instanceof P_ZeroOrMore1 || path instanceof P_ZeroOrMoreN) {
            Resource result = model.createResource();
            result.addProperty(SH.zeroOrMorePath, (RDFNode)SHACLPaths.createPath(((P_Path1)path).getSubPath(), model));
            return result;
        }
        if (path instanceof P_ZeroOrOne) {
            Resource result = model.createResource();
            result.addProperty(SH.zeroOrOnePath, (RDFNode)SHACLPaths.createPath(((P_Path1)path).getSubPath(), model));
            return result;
        }
        throw new IllegalArgumentException("Path element not supported by SHACL syntax: " + path);
    }

    public static Object getJenaPath(Resource path) throws QueryParseException {
        if (path.isURIResource()) {
            return path;
        }
        String pathString = SHACLPaths.getPathString(path);
        return SHACLPaths.getJenaPath(pathString, path.getModel());
    }

    public static Object getJenaPath(String string, Model model) throws QueryParseException {
        Query query = ARQFactory.get().createQuery(model, "ASK { ?a \n" + string + "\n ?b }");
        Element element = query.getQueryPattern();
        if (element instanceof ElementGroup) {
            Element e = (Element)((ElementGroup)element).getElements().get(0);
            if (e instanceof ElementPathBlock) {
                Path path = ((ElementPathBlock)e).getPattern().get(0).getPath();
                if (path instanceof P_Link && ((P_Link)path).isForward()) {
                    return model.asRDFNode(((P_Link)path).getNode());
                }
                return path;
            }
            if (e instanceof ElementTriplesBlock) {
                return model.asRDFNode(((ElementTriplesBlock)e).getPattern().get(0).getPredicate());
            }
        }
        throw new QueryParseException("Not a SPARQL 1.1 Path expression", 2, 1);
    }

    public static String getPathString(Resource path) {
        StringBuffer sb = new StringBuffer();
        SHACLPaths.appendPath(sb, path);
        return sb.toString();
    }
}

