/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.optimize.ClassMetadata;
import org.topbraid.shacl.optimize.OntologyOptimizableGraph;
import org.topbraid.shacl.optimize.OptimizedMultiUnion;

public class OntologyOptimizations {
    private static OntologyOptimizations singleton = new OntologyOptimizations();
    private boolean enabled;
    private static final int capacity = 10000;
    private Map<Object, Object> objects = Collections.synchronizedMap(new MyCache());

    public static OntologyOptimizations get() {
        return singleton;
    }

    public static void set(OntologyOptimizations value) {
        singleton = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public String getKeyIfEnabledFor(Graph graph) {
        Graph baseGraph;
        if (this.enabled && graph instanceof OptimizedMultiUnion && (baseGraph = JenaUtil.getBaseGraph(graph)) instanceof OntologyOptimizableGraph && ((OntologyOptimizableGraph)baseGraph).isUsingOntologyOptimizations()) {
            return ((OntologyOptimizableGraph)baseGraph).getOntologyGraphKey();
        }
        return null;
    }

    public ClassMetadata getClassMetadata(Node cls, Graph graph, String graphKey) {
        Object cacheKey = ClassMetadata.createKey(cls, graphKey);
        ClassMetadata classMetadata = (ClassMetadata)OntologyOptimizations.get().getObject(cacheKey);
        if (classMetadata == null) {
            classMetadata = new ClassMetadata(cls, graphKey);
            OntologyOptimizations.get().putObject(cacheKey, classMetadata);
        }
        return classMetadata;
    }

    public Object getObject(Object key) {
        return this.objects.get(key);
    }

    public Object getOrComputeObject(Object key, Function<Object, Object> function) {
        return this.objects.computeIfAbsent(key, function);
    }

    public List<Object> keys() {
        return new ArrayList<Object>(this.objects.keySet());
    }

    public void perhapsReset(Graph graph) {
        if ((graph = JenaUtil.getBaseGraph(graph)) instanceof OntologyOptimizableGraph) {
            if (((OntologyOptimizableGraph)graph).isOntologyGraph()) {
                this.reset();
            }
        } else if (!JenaUtil.isMemoryGraph(graph)) {
            this.reset();
        }
    }

    public void putObject(Object key, Object value) {
        this.objects.put(key, value);
    }

    public void reset() {
        this.objects.clear();
    }

    public static class MyCache
    extends LinkedHashMap<Object, Object> {
        public MyCache() {
            super(10001, 1.1f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
            return this.size() > 10000;
        }
    }
}

