/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.vocabulary.SH;

class ClosedConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private Set<RDFNode> allowedProperties = new HashSet<RDFNode>();
    private boolean closed;

    ClosedConstraintExecutor(Constraint constraint) {
        this.closed = constraint.getShapeResource().hasProperty(SH.closed, (RDFNode)JenaDatatypes.TRUE);
        RDFList list = JenaUtil.getListProperty(constraint.getShapeResource(), SH.ignoredProperties);
        if (list != null) {
            list.iterator().forEachRemaining(this.allowedProperties::add);
        }
        for (Resource ps : JenaUtil.getResourceProperties(constraint.getShapeResource(), SH.property)) {
            Resource path = ps.getPropertyResourceValue(SH.path);
            if (!path.isURIResource()) continue;
            this.allowedProperties.add((RDFNode)path);
        }
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        if (this.closed) {
            for (RDFNode focusNode : focusNodes) {
                if (focusNode instanceof Resource) {
                    StmtIterator it = ((Resource)focusNode).listProperties();
                    while (it.hasNext()) {
                        Statement s = (Statement)it.next();
                        if (this.allowedProperties.contains(s.getPredicate())) continue;
                        Resource result = engine.createValidationResult(constraint, focusNode, s.getObject(), () -> "Predicate " + engine.getLabelFunction().apply((RDFNode)s.getPredicate()) + " is not allowed (closed shape)");
                        result.removeAll(SH.resultPath);
                        result.addProperty(SH.resultPath, (RDFNode)s.getPredicate());
                    }
                }
                engine.checkCanceled();
            }
        }
        this.addStatistics(constraint, startTime);
    }
}

