/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.java.AbstractShapeListConstraintExecutor;
import org.topbraid.shacl.vocabulary.SH;

class OrConstraintExecutor
extends AbstractShapeListConstraintExecutor {
    private Set<String> datatypeURIs;

    OrConstraintExecutor(Constraint constraint) {
        super(constraint);
        if (this.hasOnlyDatatypeConstraints()) {
            this.datatypeURIs = new HashSet<String>();
            for (Resource shape : this.shapes) {
                Resource datatype = shape.getPropertyResourceValue(SH.datatype);
                this.datatypeURIs.add(datatype.getURI());
            }
        }
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        if (this.datatypeURIs != null) {
            for (RDFNode focusNode : focusNodes) {
                for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                    if (valueNode.isLiteral() && this.datatypeURIs.contains(valueNode.asNode().getLiteralDatatypeURI()) && valueNode.asNode().getLiteralDatatype().isValid(valueNode.asNode().getLiteralLexicalForm())) continue;
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value matches none of the datatypes in the sh:or enumeration");
                }
                engine.checkCanceled();
            }
        } else {
            for (RDFNode focusNode : focusNodes) {
                for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                    boolean hasOne = false;
                    for (RDFNode shape : this.shapes) {
                        Model nestedResults = this.hasShape(engine, constraint, focusNode, valueNode, shape, true);
                        if (nestedResults != null) continue;
                        hasOne = true;
                        break;
                    }
                    if (hasOne) continue;
                    engine.createValidationResult(constraint, focusNode, valueNode, () -> "Value has none of the shapes in the sh:or enumeration");
                }
            }
        }
        this.addStatistics(constraint, startTime);
    }

    private boolean hasOnlyDatatypeConstraints() {
        if (this.shapes.size() == 0) {
            return false;
        }
        for (Resource shape : this.shapes) {
            StmtIterator mit = shape.listProperties();
            if (mit.hasNext()) {
                Statement s = (Statement)mit.next();
                if (SH.datatype.equals(s.getPredicate()) && !mit.hasNext() && s.getObject().isURIResource()) continue;
                mit.close();
                return false;
            }
            return false;
        }
        return true;
    }
}

