/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.junit.Test;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.ValidationExample;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationUtil;
import org.topbraid.shacl.vocabulary.SH;

public class TestValidatorConfiguration {
    @Test
    public void testMaxErrors() {
        Model dataModel = JenaUtil.createMemoryModel();
        dataModel.read(ValidationExample.class.getResourceAsStream("/sh/tests/core/property/class-001.test.ttl"), "urn:dummy", "TURTLE");
        ValidationEngineConfiguration configuration = new ValidationEngineConfiguration();
        configuration.setValidationErrorBatch(-1);
        Resource reportNoMaximum = ValidationUtil.validateModel((Model)dataModel, (Model)dataModel, (ValidationEngineConfiguration)configuration);
        Model resultModel = reportNoMaximum.getModel();
        assert (resultModel.listStatements(null, SH.resultSeverity, (RDFNode)SH.Violation).toList().size() == 2);
        configuration.setValidationErrorBatch(1);
        Resource reportMaximum = ValidationUtil.validateModel((Model)dataModel, (Model)dataModel, (ValidationEngineConfiguration)configuration);
        resultModel = reportMaximum.getModel();
        System.out.println("FOUND " + resultModel.listStatements(null, SH.resultSeverity, (RDFNode)SH.Violation).toList().size());
        assert (resultModel.listStatements(null, SH.resultSeverity, (RDFNode)SH.Violation).toList().size() == 1);
    }
}

