/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.topbraid.shacl.expr.AbstractInputExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class LimitExpression
extends AbstractInputExpression {
    private int limit;

    public LimitExpression(RDFNode expr, NodeExpression input, int limit) {
        super(expr, input);
        this.limit = limit;
    }

    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        final ExtendedIterator<RDFNode> it = this.evalInput(focusNode, context);
        return new WrappedIterator<RDFNode>(it){
            private int count;
            {
                super(x0);
                this.count = 0;
            }

            public boolean hasNext() {
                if (this.count >= LimitExpression.this.limit) {
                    this.close();
                    return false;
                }
                return it.hasNext();
            }

            public RDFNode next() {
                RDFNode n = (RDFNode)super.next();
                ++this.count;
                return n;
            }
        };
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        return Arrays.asList(this.getInput().getFunctionalSyntax(), "" + this.limit);
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        return this.getInput().getOutputShape(contextShape);
    }

    @Override
    public String getTypeId() {
        return "limit";
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

