/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionFactory;
import org.topbraid.shacl.rules.AbstractRule;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.vocabulary.SH;

class TripleRule
extends AbstractRule {
    private NodeExpression object;
    private NodeExpression predicate;
    private NodeExpression subject;

    TripleRule(Resource resource) {
        super(resource);
        this.object = this.createNodeExpression(resource, SH.object);
        this.predicate = this.createNodeExpression(resource, SH.predicate);
        this.subject = this.createNodeExpression(resource, SH.subject);
    }

    private NodeExpression createNodeExpression(Resource resource, Property predicate) {
        Statement s = resource.getProperty(predicate);
        if (s == null) {
            throw new IllegalArgumentException("Triple rule without " + predicate.getLocalName());
        }
        return NodeExpressionFactory.get().create(s.getObject());
    }

    @Override
    public void execute(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        ProgressMonitor monitor = ruleEngine.getProgressMonitor();
        for (RDFNode focusNode : focusNodes) {
            ExtendedIterator<RDFNode> predicates;
            ExtendedIterator<RDFNode> subjects;
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            ExtendedIterator<RDFNode> objects = this.object.eval(focusNode, ruleEngine);
            if (!objects.hasNext() || !(subjects = this.subject.eval(focusNode, ruleEngine)).hasNext() || !(predicates = this.predicate.eval(focusNode, ruleEngine)).hasNext()) continue;
            List ss = subjects.toList();
            List ps = predicates.toList();
            List os = objects.toList();
            for (RDFNode subjectR : ss) {
                if (!subjectR.isResource()) continue;
                Resource subject = (Resource)subjectR;
                for (RDFNode predicateR : ps) {
                    if (!predicateR.isURIResource()) continue;
                    Property predicate = JenaUtil.asProperty((Resource)predicateR);
                    for (RDFNode object : os) {
                        ruleEngine.infer(Triple.create((Node)subject.asNode(), (Node)predicate.asNode(), (Node)object.asNode()), this, shape);
                    }
                }
            }
        }
    }

    public String toString() {
        String label = JenaUtil.getStringProperty(this.getResource(), RDFS.label);
        if (label == null) {
            label = this.subject.getFunctionalSyntax() + " - " + this.predicate.getFunctionalSyntax() + " - " + this.object.getFunctionalSyntax();
        }
        return this.getLabelStart("Triple") + label;
    }
}

