/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;

public class RecursionGuard {
    private static ThreadLocal<Set<Call>> sets = new ThreadLocal();

    public static boolean start(Node focusNode, Node shape) {
        Call call;
        Set<Call> set = sets.get();
        if (set == null) {
            set = new HashSet<Call>();
            sets.set(set);
        }
        if (set.contains(call = new Call(focusNode, shape))) {
            return true;
        }
        set.add(call);
        return false;
    }

    public static void end(Node focusNode, Node shape) {
        sets.get().remove(new Call(focusNode, shape));
    }

    private static class Call {
        private Node focusNode;
        private Node shape;

        Call(Node resource, Node shape) {
            this.focusNode = resource;
            this.shape = shape;
        }

        public boolean equals(Object other) {
            if (other instanceof Call) {
                return ((Call)other).focusNode.equals((Object)this.focusNode) && ((Call)other).shape.equals((Object)this.shape);
            }
            return false;
        }

        public int hashCode() {
            return this.focusNode.hashCode() + this.shape.hashCode();
        }

        public String toString() {
            return "(" + this.focusNode + ", " + this.shape + ")";
        }
    }
}

