/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model;

import java.util.List;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.functions.CheckRegexSyntaxFunction;
import org.topbraid.shacl.arq.functions.EvalExprPFunction;
import org.topbraid.shacl.arq.functions.HasShapeFunction;
import org.topbraid.shacl.arq.functions.IsDeactivatedFunction;
import org.topbraid.shacl.arq.functions.IsInTargetOfFunction;
import org.topbraid.shacl.arq.functions.IsValidForDatatypeFunction;
import org.topbraid.shacl.arq.functions.IsValidLangTagFunction;
import org.topbraid.shacl.arq.functions.TargetContainsMultiFunction;
import org.topbraid.shacl.arq.functions.ValuesPFunction;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHJSConstraint;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.model.SHJSFunction;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.model.SHParameterizableInstance;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.model.SHResult;
import org.topbraid.shacl.model.SHRule;
import org.topbraid.shacl.model.SHSPARQLConstraint;
import org.topbraid.shacl.model.SHSPARQLFunction;
import org.topbraid.shacl.model.SHSPARQLTarget;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.model.impl.SHConstraintComponentImpl;
import org.topbraid.shacl.model.impl.SHJSConstraintImpl;
import org.topbraid.shacl.model.impl.SHJSExecutableImpl;
import org.topbraid.shacl.model.impl.SHJSFunctionImpl;
import org.topbraid.shacl.model.impl.SHNodeShapeImpl;
import org.topbraid.shacl.model.impl.SHParameterImpl;
import org.topbraid.shacl.model.impl.SHParameterizableImpl;
import org.topbraid.shacl.model.impl.SHParameterizableInstanceImpl;
import org.topbraid.shacl.model.impl.SHParameterizableTargetImpl;
import org.topbraid.shacl.model.impl.SHPropertyShapeImpl;
import org.topbraid.shacl.model.impl.SHResultImpl;
import org.topbraid.shacl.model.impl.SHRuleImpl;
import org.topbraid.shacl.model.impl.SHSPARQLConstraintImpl;
import org.topbraid.shacl.model.impl.SHSPARQLFunctionImpl;
import org.topbraid.shacl.model.impl.SHSPARQLTargetImpl;
import org.topbraid.shacl.multifunctions.MultiFunctions;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.util.SimpleImplementation;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;

public class SHFactory {
    public static void ensureInited() {
    }

    private static void init(Personality<RDFNode> p) {
        p.add(SHConstraintComponent.class, (Implementation)new SimpleImplementation(SH.ConstraintComponent.asNode(), SHConstraintComponentImpl.class));
        p.add(SHJSConstraint.class, (Implementation)new SimpleImplementation(SH.JSConstraint.asNode(), SHJSConstraintImpl.class));
        p.add(SHJSExecutable.class, (Implementation)new SimpleImplementation(SH.JSExecutable.asNode(), SHJSExecutableImpl.class));
        p.add(SHJSFunction.class, (Implementation)new SimpleImplementation(SH.JSFunction.asNode(), SHJSFunctionImpl.class));
        p.add(SHParameter.class, (Implementation)new SimpleImplementation(SH.Parameter.asNode(), SHParameterImpl.class));
        p.add(SHParameterizable.class, (Implementation)new SimpleImplementation(SH.Parameterizable.asNode(), SHParameterizableImpl.class));
        p.add(SHParameterizableInstance.class, (Implementation)new SimpleImplementation(RDFS.Resource.asNode(), SHParameterizableInstanceImpl.class));
        p.add(SHParameterizableTarget.class, (Implementation)new SimpleImplementation(SH.Target.asNode(), SHParameterizableTargetImpl.class));
        p.add(SHPropertyShape.class, (Implementation)new SimpleImplementation(SH.PropertyShape.asNode(), SHPropertyShapeImpl.class));
        p.add(SHResult.class, (Implementation)new SimpleImplementation(SH.AbstractResult.asNode(), SHResultImpl.class));
        p.add(SHRule.class, (Implementation)new SimpleImplementation(SH.Rule.asNode(), SHRuleImpl.class));
        p.add(SHNodeShape.class, (Implementation)new SimpleImplementation(SH.NodeShape.asNode(), SHNodeShapeImpl.class));
        p.add(SHSPARQLConstraint.class, (Implementation)new SimpleImplementation(SH.SPARQLConstraint.asNode(), SHSPARQLConstraintImpl.class));
        p.add(SHSPARQLFunction.class, (Implementation)new SimpleImplementation(SH.SPARQLFunction.asNode(), SHSPARQLFunctionImpl.class));
        p.add(SHSPARQLTarget.class, (Implementation)new SimpleImplementation(SH.SPARQLTarget.asNode(), SHSPARQLTargetImpl.class));
        FunctionRegistry.get().put(DASH.isDeactivated.getURI(), IsDeactivatedFunction.class);
        FunctionRegistry.get().put(TOSH.hasShape.getURI(), HasShapeFunction.class);
        FunctionRegistry.get().put(TOSH.isInTargetOf.getURI(), IsInTargetOfFunction.class);
        FunctionRegistry.get().put("http://spinrdf.org/spif#checkRegexSyntax", CheckRegexSyntaxFunction.class);
        FunctionRegistry.get().put("http://spinrdf.org/spif#isValidForDatatype", IsValidForDatatypeFunction.class);
        FunctionRegistry.get().put("http://spinrdf.org/spif#isValidLangTag", IsValidLangTagFunction.class);
        PropertyFunctionRegistry.get().put(TOSH.evalExpr.getURI(), EvalExprPFunction.class);
        PropertyFunctionRegistry.get().put(TOSH.values.getURI(), ValuesPFunction.class);
        MultiFunctions.register(new TargetContainsMultiFunction());
    }

    public static SHConstraintComponent asConstraintComponent(RDFNode resource) {
        return (SHConstraintComponent)resource.as(SHConstraintComponent.class);
    }

    public static SHJSConstraint asJSConstraint(RDFNode node) {
        return (SHJSConstraint)node.as(SHJSConstraint.class);
    }

    public static SHSPARQLFunction asSPARQLFunction(RDFNode resource) {
        return (SHSPARQLFunction)resource.as(SHSPARQLFunction.class);
    }

    public static SHParameter asParameter(RDFNode resource) {
        return (SHParameter)resource.as(SHParameter.class);
    }

    public static SHParameterizable asParameterizable(RDFNode resource) {
        return (SHParameterizable)resource.as(SHParameterizable.class);
    }

    public static SHPropertyShape asPropertyShape(RDFNode node) {
        return (SHPropertyShape)node.as(SHPropertyShape.class);
    }

    public static SHNodeShape asNodeShape(RDFNode node) {
        return (SHNodeShape)node.as(SHNodeShape.class);
    }

    public static SHSPARQLConstraint asSPARQLConstraint(RDFNode node) {
        return (SHSPARQLConstraint)node.as(SHSPARQLConstraint.class);
    }

    public static SHSPARQLTarget asSPARQLTarget(RDFNode node) {
        return (SHSPARQLTarget)node.as(SHSPARQLTarget.class);
    }

    public static SHParameterizableInstance asTemplateCall(RDFNode resource) {
        return (SHParameterizableInstance)resource.as(SHParameterizableInstance.class);
    }

    public static SHShape asShape(RDFNode node) {
        if (node instanceof Resource && SHFactory.isPropertyShape((Resource)node)) {
            return SHFactory.asPropertyShape(node);
        }
        if (node instanceof Resource && SHFactory.isParameter((Resource)node)) {
            return SHFactory.asParameter(node);
        }
        return SHFactory.asNodeShape(node);
    }

    public static SHParameterizableTarget asParameterizableTarget(RDFNode node) {
        return (SHParameterizableTarget)node.as(SHParameterizableTarget.class);
    }

    public static boolean isJSConstraint(RDFNode node) {
        return node instanceof Resource && (JenaUtil.hasIndirectType((Resource)node, SH.JSConstraint) || !((Resource)node).hasProperty(RDF.type) && node.getModel().contains(null, SH.js, node));
    }

    public static boolean isJSTarget(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.JSTarget);
    }

    public static boolean isSPARQLConstraint(RDFNode node) {
        return node instanceof Resource && (JenaUtil.hasIndirectType((Resource)node, SH.SPARQLConstraint) || !((Resource)node).hasProperty(RDF.type) && node.getModel().contains(null, SH.sparql, node));
    }

    public static boolean isSPARQLTarget(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.SPARQLTarget);
    }

    public static boolean isNodeShape(RDFNode node) {
        if (node instanceof Resource) {
            if (JenaUtil.hasIndirectType((Resource)node, SH.NodeShape)) {
                return true;
            }
            if (node.isAnon() && !((Resource)node).hasProperty(RDF.type) && node.getModel().contains(null, SH.node, node)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameterizableConstraint(RDFNode node) {
        if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (!r.hasProperty(RDF.type)) {
                return node.getModel().contains(null, SH.property, node) || node.getModel().contains(null, SH.parameter, node);
            }
            if (r.hasProperty(RDF.type, (RDFNode)SH.NodeShape) || r.hasProperty(RDF.type, (RDFNode)SH.PropertyShape) || r.hasProperty(RDF.type, (RDFNode)SH.Parameter)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameter(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.Parameter) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.parameter, (RDFNode)resource);
    }

    public static boolean isParameterizableInstance(RDFNode node) {
        if (node instanceof Resource) {
            Resource defaultType;
            Resource resource = (Resource)node;
            List<Resource> types = JenaUtil.getTypes(resource);
            for (Resource type : types) {
                if (!JenaUtil.hasIndirectType(type, SH.Parameterizable)) continue;
                return true;
            }
            if (types.isEmpty() && (defaultType = SHACLUtil.getResourceDefaultType(resource)) != null && JenaUtil.hasIndirectType(defaultType, SH.Parameterizable)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyShape(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)SH.PropertyShape) || resource.getModel().contains(null, SH.property, (RDFNode)resource);
    }

    static {
        SHFactory.init((Personality<RDFNode>)BuiltinPersonalities.model);
    }
}

