/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.multifunctions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaNodeUtil;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.multifunctions.MultiFunction;
import org.topbraid.shacl.multifunctions.MultiFunctionParameter;
import org.topbraid.shacl.util.OrderThenPathLocalNameComparator;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public abstract class AbstractMultiFunction
implements MultiFunction {
    private Node apiStatus;
    private String description;
    private List<MultiFunctionParameter> parameters;
    private List<MultiFunctionParameter> resultVars;
    private String uri;

    protected AbstractMultiFunction(String uri, Resource declaration) {
        Objects.requireNonNull(uri, "uri");
        this.uri = uri;
        Objects.requireNonNull(declaration, "declaration");
        this.initFrom(declaration);
    }

    protected AbstractMultiFunction(String uri, List<String> argVarNames, List<String> resultVarNames) {
        Objects.requireNonNull(uri, "uri");
        this.uri = uri;
        this.parameters = argVarNames.stream().map(varName -> new MultiFunctionParameter((String)varName, null, true, null)).collect(Collectors.toList());
        this.resultVars = resultVarNames.stream().map(varName -> new MultiFunctionParameter((String)varName, null, true, null)).collect(Collectors.toList());
    }

    private static List<MultiFunctionParameter> createParameters(Resource declaration, Property predicate) {
        List<Resource> params = JenaUtil.getResourceProperties(declaration, predicate);
        Collections.sort(params, OrderThenPathLocalNameComparator.get());
        List<MultiFunctionParameter> parameters = params.stream().map(param -> MultiFunctionParameter.create(param)).collect(Collectors.toList());
        return parameters;
    }

    @Override
    public Node getAPIStatus() {
        return this.apiStatus;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<MultiFunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<MultiFunctionParameter> getResultVars() {
        return this.resultVars;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public void initFrom(Resource declaration) {
        this.apiStatus = JenaNodeUtil.getObject(declaration.asNode(), DASH.apiStatus.asNode(), declaration.getModel().getGraph());
        this.description = JenaUtil.getStringProperty(declaration, RDFS.comment);
        this.parameters = AbstractMultiFunction.createParameters(declaration, SH.parameter);
        this.resultVars = AbstractMultiFunction.createParameters(declaration, DASH.resultVariable);
        if (this.resultVars.isEmpty()) {
            throw new IllegalArgumentException("A multi-function requires at least one result variable");
        }
    }
}

