/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.rules.RuleEngine;

class ValuesRule
implements Rule {
    private NodeExpression expr;
    private boolean inverse;
    private Node predicate;

    ValuesRule(NodeExpression expr, Node predicate, boolean inverse) {
        this.expr = expr;
        this.predicate = predicate;
        this.inverse = inverse;
    }

    @Override
    public void execute(RuleEngine ruleEngine, List<RDFNode> focusNodes, Shape shape) {
        ProgressMonitor monitor = ruleEngine.getProgressMonitor();
        for (RDFNode focusNode : focusNodes) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            ExtendedIterator<RDFNode> objects = this.expr.eval(focusNode, ruleEngine);
            while (objects.hasNext()) {
                RDFNode object = (RDFNode)objects.next();
                Triple triple = this.inverse ? Triple.create((Node)object.asNode(), (Node)this.predicate, (Node)focusNode.asNode()) : Triple.create((Node)focusNode.asNode(), (Node)this.predicate, (Node)object.asNode());
                ruleEngine.infer(triple, this, shape);
            }
        }
    }

    @Override
    public Node getContextNode() {
        return this.expr.getRDFNode().asNode();
    }

    @Override
    public Number getOrder() {
        return 0;
    }

    public String toString() {
        String label = this.expr.toString();
        return label;
    }
}

