/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaNodeUtil;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.model.SHResult;
import org.topbraid.shacl.optimize.OntologyOptimizations;
import org.topbraid.shacl.optimize.OptimizedMultiUnion;
import org.topbraid.shacl.targets.CustomTargetLanguage;
import org.topbraid.shacl.targets.CustomTargets;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class SHACLUtil {
    public static final Resource[] RESULT_TYPES = new Resource[]{DASH.FailureResult, DASH.SuccessResult, SH.ValidationResult};
    public static final String SHAPES_FILE_PART = ".shapes.";
    public static final String URN_X_SHACL = "urn:x-shacl:";
    private static final Set<Property> SPARQL_PROPERTIES = new HashSet<Property>();
    private static Query propertyLabelQuery;

    public static void addDirectPropertiesOfClass(Resource cls, Collection<Property> results) {
        Resource predicate;
        for (Resource argument : JenaUtil.getResourceProperties(cls, SH.parameter)) {
            predicate = argument.getPropertyResourceValue(SH.path);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
        for (Resource property : JenaUtil.getResourceProperties(cls, SH.property)) {
            predicate = property.getPropertyResourceValue(SH.path);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
    }

    private static void addIncludes(Graph model, String uri, Set<Graph> graphs, Set<String> reachedURIs) {
        graphs.add(model);
        reachedURIs.add(uri);
        for (Triple t : model.find(null, OWL.imports.asNode(), null).toList()) {
            Model includeModel;
            String includeURI;
            if (!t.getObject().isURI() || reachedURIs.contains(includeURI = t.getObject().getURI()) || (includeModel = ARQFactory.getNamedModel(includeURI)) == null) continue;
            Graph includeGraph = includeModel.getGraph();
            SHACLUtil.addIncludes(includeGraph, includeURI, graphs, reachedURIs);
        }
    }

    public static void addNodesInTarget(Resource target, Dataset dataset, Set<Node> results) {
        for (RDFNode focusNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
            results.add(focusNode.asNode());
        }
    }

    public static Model createIncludesModel(Model model, String graphURI) {
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        SHACLUtil.addIncludes(baseGraph, graphURI, graphs, new HashSet<String>());
        if (graphs.size() == 1) {
            return model;
        }
        MultiUnion union = new MultiUnion(graphs.iterator());
        union.setBaseGraph(baseGraph);
        return ModelFactory.createModelForGraph((Graph)union);
    }

    public static URI createRandomShapesGraphURI() {
        return URI.create(URN_X_SHACL + UUID.randomUUID());
    }

    public static Set<Node> getAllFocusNodes(Dataset dataset, boolean validateShapes) {
        Property predicate;
        HashSet<Node> results = new HashSet<Node>();
        Model model = dataset.getDefaultModel();
        for (Resource shape : JenaUtil.getAllInstances(SH.Shape.inModel(model))) {
            if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
            for (Resource instance : JenaUtil.getAllInstances(shape)) {
                results.add(instance.asNode());
            }
        }
        for (Statement s : model.listStatements(null, SH.targetClass, (RDFNode)null).toList()) {
            if (!s.getObject().isResource() || !validateShapes && (JenaUtil.hasIndirectType(s.getSubject(), SH.ConstraintComponent) || SH.PropertyShape.equals((Object)s.getObject()) || SH.Constraint.equals((Object)s.getObject()))) continue;
            for (Resource instance : JenaUtil.getAllInstances(s.getResource())) {
                results.add(instance.asNode());
            }
        }
        for (Statement s : model.listStatements(null, SH.targetNode, (RDFNode)null).toList()) {
            results.add(s.getObject().asNode());
        }
        for (Statement s : model.listStatements(null, SH.target, (RDFNode)null).toList()) {
            if (!s.getObject().isResource()) continue;
            Resource target = s.getResource();
            for (RDFNode focusNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
                results.add(focusNode.asNode());
            }
        }
        for (RDFNode property : model.listObjectsOfProperty(SH.targetObjectsOf).toList()) {
            if (!property.isURIResource()) continue;
            predicate = JenaUtil.asProperty((Resource)property);
            for (RDFNode focusNode : model.listObjectsOfProperty(predicate).toList()) {
                results.add(focusNode.asNode());
            }
        }
        for (RDFNode property : model.listObjectsOfProperty(SH.targetSubjectsOf).toList()) {
            if (!property.isURIResource()) continue;
            predicate = JenaUtil.asProperty((Resource)property);
            for (RDFNode focusNode : model.listSubjectsWithProperty(predicate).toList()) {
                results.add(focusNode.asNode());
            }
        }
        return results;
    }

    public static List<SHResult> getAllTopLevelResults(Model model) {
        LinkedList<SHResult> results = new LinkedList<SHResult>();
        for (Resource type : RESULT_TYPES) {
            for (Resource r : model.listResourcesWithProperty(RDF.type, (RDFNode)type).toList()) {
                if (model.contains(null, SH.detail, (RDFNode)r)) continue;
                results.add((SHResult)r.as(SHResult.class));
            }
        }
        return results;
    }

    public static Set<Resource> getAllSuperClassesAndShapesStar(Resource cls) {
        HashSet<Resource> results = new HashSet<Resource>();
        SHACLUtil.getAllSuperClassesAndShapesStarHelper(cls, results);
        return results;
    }

    private static void getAllSuperClassesAndShapesStarHelper(Resource node, Set<Resource> results) {
        if (!results.contains(node)) {
            results.add(node);
            StmtIterator it = node.listProperties(RDFS.subClassOf);
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                if (!s.getObject().isResource()) continue;
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(s.getResource(), results);
            }
            it = node.getModel().listStatements(null, SH.targetClass, (RDFNode)node);
            while (it.hasNext()) {
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(((Statement)it.next()).getSubject(), results);
            }
        }
    }

    public static SHConstraintComponent getConstraintComponentOfValidator(Resource validator) {
        for (Statement s : validator.getModel().listStatements(null, null, (RDFNode)validator).toList()) {
            if (!SH.validator.equals(s.getPredicate()) && !SH.nodeValidator.equals(s.getPredicate()) && !SH.propertyValidator.equals(s.getPredicate())) continue;
            return (SHConstraintComponent)s.getSubject().as(SHConstraintComponent.class);
        }
        return null;
    }

    public static Resource getDefaultTypeForConstraintPredicate(Property predicate) {
        if (SH.property.equals(predicate)) {
            return SH.PropertyShape;
        }
        if (SH.parameter.equals(predicate)) {
            return SH.Parameter;
        }
        throw new IllegalArgumentException();
    }

    public static SHParameter getParameterAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.parameter)) {
                if (!arg.hasProperty(SH.path, (RDFNode)predicate)) continue;
                return SHFactory.asParameter((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHParameter getParameterAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHParameter argument = SHACLUtil.getParameterAtClass(type, predicate);
            if (argument == null) continue;
            return argument;
        }
        return null;
    }

    public static Resource getResourceDefaultType(Resource resource) {
        if (resource.getModel().contains(null, SH.property, (RDFNode)resource)) {
            return SH.PropertyShape.inModel(resource.getModel());
        }
        if (resource.getModel().contains(null, SH.parameter, (RDFNode)resource)) {
            return SH.Parameter.inModel(resource.getModel());
        }
        return null;
    }

    public static String getLocalPropertyLabel(Resource property, Resource context) {
        QuerySolutionMap binding = new QuerySolutionMap();
        binding.add("arg1", (RDFNode)property);
        binding.add("arg2", (RDFNode)context);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(propertyLabelQuery, property.getModel(), (QuerySolution)binding);){
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                String string = rs.next().get("label").asLiteral().getLexicalForm();
                return string;
            }
        }
        return null;
    }

    public static SHPropertyShape getPropertyConstraintAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.property)) {
                if (!arg.hasProperty(SH.path, (RDFNode)predicate)) continue;
                return SHFactory.asPropertyShape((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHPropertyShape getPropertyConstraintAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHPropertyShape property = SHACLUtil.getPropertyConstraintAtClass(type, predicate);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public static List<Property> getAllPropertiesOfClass(Resource cls) {
        LinkedList<Property> results = new LinkedList<Property>();
        for (Resource c : SHACLUtil.getAllSuperClassesAndShapesStar(cls)) {
            SHACLUtil.addDirectPropertiesOfClass(c, results);
        }
        return results;
    }

    public static Iterable<RDFNode> getResourcesInTarget(Resource target, Dataset dataset) {
        Resource executable;
        Resource type = JenaUtil.getType(target);
        SHParameterizableTarget parameterizableTarget = null;
        if (SHFactory.isParameterizableInstance((RDFNode)target)) {
            executable = type;
            parameterizableTarget = SHFactory.asParameterizableTarget((RDFNode)target);
        } else {
            executable = target;
        }
        CustomTargetLanguage plugin = CustomTargets.get().getLanguageForTarget(executable);
        if (plugin != null) {
            HashSet<RDFNode> results = new HashSet<RDFNode>();
            plugin.createTarget(executable, parameterizableTarget).addTargetNodes(dataset, results);
            return results;
        }
        return new ArrayList<RDFNode>();
    }

    public static List<SHNodeShape> getAllShapesAtNode(RDFNode node) {
        return SHACLUtil.getAllShapesAtNode(node, node instanceof Resource ? JenaUtil.getTypes((Resource)node) : null);
    }

    public static List<SHNodeShape> getAllShapesAtNode(RDFNode node, Iterable<Resource> types) {
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        if (node instanceof Resource) {
            HashSet<Resource> reached = new HashSet<Resource>();
            for (Resource type : types) {
                SHACLUtil.addAllShapesAtClassOrShape(type, results, reached);
            }
        }
        return results;
    }

    public static List<SHNodeShape> getAllShapesAtClassOrShape(Resource clsOrShape) {
        Object key = OntologyOptimizations.get().getKeyIfEnabledFor(clsOrShape.getModel().getGraph());
        if (key != null) {
            key = (String)key + ".getAllShapesAtClassOrShape(" + clsOrShape + ")";
            return (List)OntologyOptimizations.get().getOrComputeObject(key, () -> {
                LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
                SHACLUtil.addAllShapesAtClassOrShape(clsOrShape, results, new HashSet<Resource>());
                return results;
            });
        }
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        SHACLUtil.addAllShapesAtClassOrShape(clsOrShape, results, new HashSet<Resource>());
        return results;
    }

    private static void addAllShapesAtClassOrShape(Resource clsOrShape, List<SHNodeShape> results, Set<Resource> reached) {
        SHACLUtil.addDirectShapesAtClassOrShape(clsOrShape, results);
        reached.add(clsOrShape);
        for (Resource superClass : JenaUtil.getSuperClasses(clsOrShape)) {
            if (reached.contains(superClass)) continue;
            SHACLUtil.addAllShapesAtClassOrShape(superClass, results, reached);
        }
    }

    public static Collection<SHNodeShape> getDirectShapesAtClassOrShape(Resource clsOrShape) {
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        SHACLUtil.addDirectShapesAtClassOrShape(clsOrShape, results);
        return results;
    }

    private static void addDirectShapesAtClassOrShape(Resource clsOrShape, List<SHNodeShape> results) {
        SHNodeShape shape;
        if (JenaUtil.hasIndirectType(clsOrShape, SH.Shape) && !results.contains(clsOrShape) && !(shape = SHFactory.asNodeShape((RDFNode)clsOrShape)).isDeactivated()) {
            results.add(shape);
        }
        StmtIterator it = clsOrShape.getModel().listStatements(null, SH.targetClass, (RDFNode)clsOrShape);
        while (it.hasNext()) {
            SHNodeShape shape2;
            Resource subject = ((Statement)it.next()).getSubject();
            if (results.contains(subject) || (shape2 = SHFactory.asNodeShape((RDFNode)subject)).isDeactivated()) continue;
            results.add(shape2);
        }
    }

    public static Set<Resource> getDirectShapesAtResource(Resource resource) {
        HashSet<Resource> shapes = new HashSet<Resource>();
        for (Resource type : JenaUtil.getResourceProperties(resource, RDF.type)) {
            if (JenaUtil.hasIndirectType(type, SH.NodeShape)) {
                shapes.add(type);
            }
            Set<Resource> ts = JenaUtil.getAllSuperClassesStar(type);
            for (Resource s : ts) {
                Resource shape;
                StmtIterator it = type.getModel().listStatements(null, DASH.applicableToClass, (RDFNode)s);
                while (it.hasNext()) {
                    shape = ((Statement)it.next()).getSubject();
                    shapes.add(shape);
                }
                it = type.getModel().listStatements(null, SH.targetClass, (RDFNode)s);
                while (it.hasNext()) {
                    shape = ((Statement)it.next()).getSubject();
                    shapes.add(shape);
                }
            }
        }
        return shapes;
    }

    public static List<RDFNode> getTargetNodes(Resource shape, Dataset dataset) {
        return SHACLUtil.getTargetNodes(shape, dataset, false);
    }

    public static List<RDFNode> getTargetNodes(Resource shape, Dataset dataset, boolean includeApplicableToClass) {
        Model dataModel = dataset.getDefaultModel();
        HashSet<Object> results = new HashSet<Object>();
        if (JenaUtil.hasIndirectType(shape, RDFS.Class)) {
            results.addAll(JenaUtil.getAllInstances(shape.inModel(dataModel)));
        }
        for (Resource targetClass : JenaUtil.getResourceProperties(shape, SH.targetClass)) {
            results.addAll(JenaUtil.getAllInstances(targetClass.inModel(dataModel)));
        }
        for (RDFNode targetNode : shape.getModel().listObjectsOfProperty(shape, SH.targetNode).toList()) {
            results.add(targetNode.inModel(dataModel));
        }
        for (Resource sof : JenaUtil.getResourceProperties(shape, SH.targetSubjectsOf)) {
            for (Statement s : dataModel.listStatements(null, JenaUtil.asProperty(sof), (RDFNode)null).toList()) {
                results.add(s.getSubject());
            }
        }
        for (Resource sof : JenaUtil.getResourceProperties(shape, SH.targetObjectsOf)) {
            for (Statement s : dataModel.listStatements(null, JenaUtil.asProperty(sof), (RDFNode)null).toList()) {
                results.add(s.getObject());
            }
        }
        for (Resource target : JenaUtil.getResourceProperties(shape, SH.target)) {
            for (RDFNode targetNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
                results.add(targetNode);
            }
        }
        if (includeApplicableToClass) {
            for (Resource targetClass : JenaUtil.getResourceProperties(shape, DASH.applicableToClass)) {
                results.addAll(JenaUtil.getAllInstances(targetClass.inModel(dataModel)));
            }
        }
        return new ArrayList<RDFNode>(results);
    }

    public static List<Resource> getTypes(Resource subject) {
        Resource defaultType;
        List<Resource> types = JenaUtil.getTypes(subject);
        if (types.isEmpty() && (defaultType = SHACLUtil.getResourceDefaultType(subject)) != null) {
            return Collections.singletonList(defaultType);
        }
        return types;
    }

    public static boolean hasMinSeverity(Resource severity, Resource minSeverity) {
        if (minSeverity == null || SH.Info.equals((Object)minSeverity)) {
            return true;
        }
        if (SH.Warning.equals((Object)minSeverity)) {
            return !SH.Info.equals((Object)severity);
        }
        return SH.Violation.equals((Object)severity);
    }

    public static boolean isParameterAtInstance(Resource subject, Property predicate) {
        for (Resource type : SHACLUtil.getTypes(subject)) {
            SHParameter arg = SHACLUtil.getParameterAtClass(type, predicate);
            if (arg == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isSPARQLProperty(Property property) {
        return SPARQL_PROPERTIES.contains(property);
    }

    public static boolean exists(Model model) {
        return model != null && SHACLUtil.exists(model.getGraph());
    }

    public static boolean exists(Graph graph) {
        if (graph instanceof OptimizedMultiUnion) {
            return ((OptimizedMultiUnion)graph).getIncludesSHACL();
        }
        return graph != null && "http://www.w3.org/ns/shacl#".equals(graph.getPrefixMapping().getNsPrefixURI("sh")) && graph.contains(SH.Shape.asNode(), RDF.type.asNode(), Node.ANY);
    }

    public static URI withShapesGraph(Dataset dataset) {
        URI shapesGraphURI = SHACLUtil.createRandomShapesGraphURI();
        Model shapesModel = SHACLUtil.createShapesModel(dataset);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        return shapesGraphURI;
    }

    private static Model createShapesModel(Dataset dataset) {
        Model model = dataset.getDefaultModel();
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        graphs.add(baseGraph);
        for (Statement s : model.listStatements(null, SH.shapesGraph, (RDFNode)null).toList()) {
            if (!s.getObject().isURIResource()) continue;
            String graphURI = s.getResource().getURI();
            Model sm = dataset.getNamedModel(graphURI);
            graphs.add(sm.getGraph());
        }
        if (graphs.size() > 1) {
            MultiUnion union = new MultiUnion(graphs.iterator());
            union.setBaseGraph(baseGraph);
            return ModelFactory.createModelForGraph((Graph)union);
        }
        return model;
    }

    public static boolean isInTarget(RDFNode focusNode, Dataset dataset, Resource target) {
        CustomTargetLanguage plugin;
        SHParameterizableTarget parameterizableTarget = null;
        Resource executable = target;
        if (SHFactory.isParameterizableInstance((RDFNode)target)) {
            parameterizableTarget = SHFactory.asParameterizableTarget((RDFNode)target);
            executable = parameterizableTarget.getParameterizable();
        }
        if ((plugin = CustomTargets.get().getLanguageForTarget(executable)) != null) {
            return plugin.createTarget(executable, parameterizableTarget).contains(dataset, focusNode);
        }
        return false;
    }

    public static Node walkPropertyShapesHelper(Node propertyShape, Graph graph) {
        Node valueType = JenaNodeUtil.getObject(propertyShape, SH.class_.asNode(), graph);
        if (valueType != null) {
            return valueType;
        }
        Node datatype = JenaNodeUtil.getObject(propertyShape, SH.datatype.asNode(), graph);
        if (datatype != null) {
            return datatype;
        }
        ExtendedIterator ors = graph.find(propertyShape, SH.or.asNode(), Node.ANY);
        while (ors.hasNext()) {
            Node or = ((Triple)ors.next()).getObject();
            Node first = JenaNodeUtil.getObject(or, RDF.first.asNode(), graph);
            if (first.isLiteral()) continue;
            Node cls = JenaNodeUtil.getObject(first, SH.class_.asNode(), graph);
            if (cls != null) {
                ors.close();
                return cls;
            }
            datatype = JenaNodeUtil.getObject(first, SH.datatype.asNode(), graph);
            if (datatype == null) continue;
            ors.close();
            return datatype;
        }
        if (graph.contains(propertyShape, SH.node.asNode(), DASH.ListShape.asNode())) {
            return RDF.List.asNode();
        }
        return null;
    }

    static {
        SPARQL_PROPERTIES.add(SH.ask);
        SPARQL_PROPERTIES.add(SH.construct);
        SPARQL_PROPERTIES.add(SH.select);
        SPARQL_PROPERTIES.add(SH.update);
        propertyLabelQuery = ARQFactory.get().createQuery("PREFIX rdfs: <" + RDFS.getURI() + ">\nPREFIX sh: <http://www.w3.org/ns/shacl#>\nSELECT ?label\nWHERE {\n    ?arg2 a ?type .\n    ?type rdfs:subClassOf* ?class .\n    ?shape <" + SH.targetClass + ">* ?class .\n    ?shape <" + SH.property + ">|<" + SH.parameter + "> ?p .\n    ?p <" + SH.path + "> ?arg1 .\n    ?p rdfs:label ?label .\n}");
    }
}

