/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.AbstractNativeConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.vocabulary.SH;

class QualifiedValueShapeConstraintExecutor
extends AbstractNativeConstraintExecutor {
    private boolean disjoint;
    private Integer maxCount;
    private Integer minCount;
    private Set<Resource> siblings = new HashSet<Resource>();
    private Resource valueShape;

    QualifiedValueShapeConstraintExecutor(Constraint constraint) {
        this.valueShape = constraint.getShapeResource().getPropertyResourceValue(SH.qualifiedValueShape);
        this.disjoint = constraint.getShapeResource().hasProperty(SH.qualifiedValueShapesDisjoint, (RDFNode)JenaDatatypes.TRUE);
        if (this.disjoint) {
            for (Resource parent : constraint.getShapeResource().getModel().listSubjectsWithProperty(SH.property, (RDFNode)constraint.getShapeResource()).toList()) {
                for (Resource ps : JenaUtil.getResourceProperties(parent, SH.property)) {
                    this.siblings.addAll(JenaUtil.getResourceProperties(ps, SH.qualifiedValueShape));
                }
            }
            this.siblings.remove(this.valueShape);
        }
        this.maxCount = JenaUtil.getIntegerProperty(constraint.getShapeResource(), SH.qualifiedMaxCount);
        this.minCount = JenaUtil.getIntegerProperty(constraint.getShapeResource(), SH.qualifiedMinCount);
    }

    private boolean hasAnySiblingShape(ValidationEngine engine, Constraint constraint, RDFNode focusNode, RDFNode valueNode) {
        for (Resource sibling : this.siblings) {
            Model results = this.hasShape(engine, constraint, focusNode, valueNode, (RDFNode)sibling, true);
            if (results != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, Collection<RDFNode> focusNodes) {
        long startTime = System.currentTimeMillis();
        if (this.minCount != null && this.maxCount != null && SH.QualifiedMinCountConstraintComponent.equals((Object)constraint.getComponent())) {
            return;
        }
        long valueNodeCount = 0L;
        for (RDFNode focusNode : focusNodes) {
            Resource result;
            int count = 0;
            for (RDFNode valueNode : engine.getValueNodes(constraint, focusNode)) {
                ++valueNodeCount;
                Model results = this.hasShape(engine, constraint, focusNode, valueNode, (RDFNode)this.valueShape, true);
                if (results != null || this.hasAnySiblingShape(engine, constraint, focusNode, valueNode)) continue;
                ++count;
            }
            if (this.maxCount != null && count > this.maxCount) {
                result = engine.createValidationResult(constraint, focusNode, null, () -> "More than " + this.maxCount + " values have shape " + engine.getLabelFunction().apply((RDFNode)this.valueShape));
                result.removeAll(SH.sourceConstraintComponent);
                result.addProperty(SH.sourceConstraintComponent, (RDFNode)SH.QualifiedMaxCountConstraintComponent);
            }
            if (this.minCount != null && count < this.minCount) {
                result = engine.createValidationResult(constraint, focusNode, null, () -> "Less than " + this.minCount + " values have shape " + engine.getLabelFunction().apply((RDFNode)this.valueShape));
                result.removeAll(SH.sourceConstraintComponent);
                result.addProperty(SH.sourceConstraintComponent, (RDFNode)SH.QualifiedMinCountConstraintComponent);
            }
            engine.checkCanceled();
        }
        this.addStatistics(engine, constraint, startTime, focusNodes.size(), valueNodeCount);
    }
}

