/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.JenaUtil;

public class JenaNodeUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node getObject(Node subject, Node predicate, Graph graph) {
        try (ExtendedIterator it = graph.find(subject, predicate, Node.ANY);){
            Node node = it.hasNext() ? ((Triple)it.next()).getObject() : null;
            return node;
        }
    }

    public static long getObjectCount(Node subject, Node predicate, Graph graph) {
        return Iter.count((Iterator)graph.find(subject, predicate, Node.ANY));
    }

    public static List<Node> getObjects(Node subject, Node predicate, Graph graph) {
        LinkedList<Node> results = new LinkedList<Node>();
        ExtendedIterator it = graph.find(subject, predicate, Node.ANY);
        while (it.hasNext()) {
            results.add(((Triple)it.next()).getObject());
        }
        return results;
    }

    public static long getSubjectCount(Node predicate, Node object, Graph graph) {
        return Iter.count((Iterator)graph.find(Node.ANY, predicate, object));
    }

    public static List<Node> getSubjects(Node predicate, Node object, Graph graph) {
        LinkedList<Node> results = new LinkedList<Node>();
        ExtendedIterator it = graph.find(Node.ANY, predicate, object);
        while (it.hasNext()) {
            results.add(((Triple)it.next()).getSubject());
        }
        return results;
    }

    public static boolean isInstanceOf(Node instance, Node type, Graph graph) {
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        return JenaUtil.hasIndirectType((Resource)model.asRDFNode(instance), (Resource)model.asRDFNode(type));
    }
}

