/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2;
import org.apache.jena.sparql.expr.ExprList;

public class QueryIterNestedLoopLeftJoin
extends QueryIter2 {
    private long s_countLHS = 0L;
    private long s_countRHS = 0L;
    private long s_countResults = 0L;
    private final ExprList conditions;
    private final List<Binding> rightRows;
    private Iterator<Binding> right = null;
    private QueryIterator left;
    private Binding rowLeft = null;
    private boolean foundMatch;
    private Binding slot = null;
    private boolean finished = false;

    public QueryIterNestedLoopLeftJoin(QueryIterator left, QueryIterator right, ExprList exprList, ExecutionContext cxt) {
        super(left, right, cxt);
        this.conditions = exprList;
        this.rightRows = Iter.toList((Iterator)right);
        this.s_countRHS = this.rightRows.size();
        this.left = left;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.finished) {
            return false;
        }
        if (this.slot == null) {
            this.slot = this.moveToNextBindingOrNull();
            if (this.slot == null) {
                this.close();
                return false;
            }
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding r = this.slot;
        this.slot = null;
        return r;
    }

    protected Binding moveToNextBindingOrNull() {
        if (this.isFinished()) {
            return null;
        }
        while (true) {
            if (this.rowLeft == null) {
                if (this.left.hasNext()) {
                    this.rowLeft = (Binding)this.left.next();
                    this.foundMatch = false;
                    ++this.s_countLHS;
                    this.right = this.rightRows.iterator();
                } else {
                    return null;
                }
            }
            while (this.right.hasNext()) {
                Binding rowRight = this.right.next();
                Binding r = Algebra.merge(this.rowLeft, rowRight);
                if (r == null || !this.applyConditions(r)) continue;
                ++this.s_countResults;
                this.foundMatch = true;
                return r;
            }
            if (!this.foundMatch) {
                ++this.s_countResults;
                Binding r = this.rowLeft;
                this.rowLeft = null;
                return r;
            }
            this.rowLeft = null;
        }
    }

    private boolean applyConditions(Binding binding) {
        if (this.conditions == null) {
            return true;
        }
        return this.conditions.isSatisfied(binding, this.getExecContext());
    }

    @Override
    protected void requestSubCancel() {
    }

    @Override
    protected void closeSubIterator() {
    }
}

